// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Statistics for a single scheduled query run.
 */
public class ExecutionStats private constructor(builder: Builder) {
    /**
     * Bytes metered for a single scheduled query run.
     */
    public val bytesMetered: kotlin.Long = builder.bytesMetered
    /**
     * Bytes scanned for a single scheduled query run.
     */
    public val cumulativeBytesScanned: kotlin.Long = builder.cumulativeBytesScanned
    /**
     * Data writes metered for records ingested in a single scheduled query run.
     */
    public val dataWrites: kotlin.Long = builder.dataWrites
    /**
     * Total time, measured in milliseconds, that was needed for the scheduled query run to complete.
     */
    public val executionTimeInMillis: kotlin.Long = builder.executionTimeInMillis
    /**
     * Number of rows present in the output from running a query before ingestion to destination data source.
     */
    public val queryResultRows: kotlin.Long = builder.queryResultRows
    /**
     * The number of records ingested for a single scheduled query run.
     */
    public val recordsIngested: kotlin.Long = builder.recordsIngested

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.ExecutionStats = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecutionStats(")
        append("bytesMetered=$bytesMetered,")
        append("cumulativeBytesScanned=$cumulativeBytesScanned,")
        append("dataWrites=$dataWrites,")
        append("executionTimeInMillis=$executionTimeInMillis,")
        append("queryResultRows=$queryResultRows,")
        append("recordsIngested=$recordsIngested")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytesMetered.hashCode()
        result = 31 * result + (cumulativeBytesScanned.hashCode())
        result = 31 * result + (dataWrites.hashCode())
        result = 31 * result + (executionTimeInMillis.hashCode())
        result = 31 * result + (queryResultRows.hashCode())
        result = 31 * result + (recordsIngested.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecutionStats

        if (bytesMetered != other.bytesMetered) return false
        if (cumulativeBytesScanned != other.cumulativeBytesScanned) return false
        if (dataWrites != other.dataWrites) return false
        if (executionTimeInMillis != other.executionTimeInMillis) return false
        if (queryResultRows != other.queryResultRows) return false
        if (recordsIngested != other.recordsIngested) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.ExecutionStats = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Bytes metered for a single scheduled query run.
         */
        public var bytesMetered: kotlin.Long = 0L
        /**
         * Bytes scanned for a single scheduled query run.
         */
        public var cumulativeBytesScanned: kotlin.Long = 0L
        /**
         * Data writes metered for records ingested in a single scheduled query run.
         */
        public var dataWrites: kotlin.Long = 0L
        /**
         * Total time, measured in milliseconds, that was needed for the scheduled query run to complete.
         */
        public var executionTimeInMillis: kotlin.Long = 0L
        /**
         * Number of rows present in the output from running a query before ingestion to destination data source.
         */
        public var queryResultRows: kotlin.Long = 0L
        /**
         * The number of records ingested for a single scheduled query run.
         */
        public var recordsIngested: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.ExecutionStats) : this() {
            this.bytesMetered = x.bytesMetered
            this.cumulativeBytesScanned = x.cumulativeBytesScanned
            this.dataWrites = x.dataWrites
            this.executionTimeInMillis = x.executionTimeInMillis
            this.queryResultRows = x.queryResultRows
            this.recordsIngested = x.recordsIngested
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.ExecutionStats = ExecutionStats(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
