// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.timestreamquery.auth.DefaultTimestreamQueryAuthSchemeProvider
import aws.sdk.kotlin.services.timestreamquery.auth.TimestreamQueryAuthSchemeProvider
import aws.sdk.kotlin.services.timestreamquery.endpoints.DefaultTimestreamQueryEndpointProvider
import aws.sdk.kotlin.services.timestreamquery.endpoints.TimestreamQueryEndpointDiscoverer
import aws.sdk.kotlin.services.timestreamquery.endpoints.TimestreamQueryEndpointParameters
import aws.sdk.kotlin.services.timestreamquery.endpoints.TimestreamQueryEndpointProvider
import aws.sdk.kotlin.services.timestreamquery.model.CancelQueryRequest
import aws.sdk.kotlin.services.timestreamquery.model.CancelQueryResponse
import aws.sdk.kotlin.services.timestreamquery.model.CreateScheduledQueryRequest
import aws.sdk.kotlin.services.timestreamquery.model.CreateScheduledQueryResponse
import aws.sdk.kotlin.services.timestreamquery.model.DeleteScheduledQueryRequest
import aws.sdk.kotlin.services.timestreamquery.model.DeleteScheduledQueryResponse
import aws.sdk.kotlin.services.timestreamquery.model.DescribeAccountSettingsRequest
import aws.sdk.kotlin.services.timestreamquery.model.DescribeAccountSettingsResponse
import aws.sdk.kotlin.services.timestreamquery.model.DescribeEndpointsRequest
import aws.sdk.kotlin.services.timestreamquery.model.DescribeEndpointsResponse
import aws.sdk.kotlin.services.timestreamquery.model.DescribeScheduledQueryRequest
import aws.sdk.kotlin.services.timestreamquery.model.DescribeScheduledQueryResponse
import aws.sdk.kotlin.services.timestreamquery.model.ExecuteScheduledQueryRequest
import aws.sdk.kotlin.services.timestreamquery.model.ExecuteScheduledQueryResponse
import aws.sdk.kotlin.services.timestreamquery.model.ListScheduledQueriesRequest
import aws.sdk.kotlin.services.timestreamquery.model.ListScheduledQueriesResponse
import aws.sdk.kotlin.services.timestreamquery.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.timestreamquery.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.timestreamquery.model.PrepareQueryRequest
import aws.sdk.kotlin.services.timestreamquery.model.PrepareQueryResponse
import aws.sdk.kotlin.services.timestreamquery.model.QueryRequest
import aws.sdk.kotlin.services.timestreamquery.model.QueryResponse
import aws.sdk.kotlin.services.timestreamquery.model.TagResourceRequest
import aws.sdk.kotlin.services.timestreamquery.model.TagResourceResponse
import aws.sdk.kotlin.services.timestreamquery.model.UntagResourceRequest
import aws.sdk.kotlin.services.timestreamquery.model.UntagResourceResponse
import aws.sdk.kotlin.services.timestreamquery.model.UpdateAccountSettingsRequest
import aws.sdk.kotlin.services.timestreamquery.model.UpdateAccountSettingsResponse
import aws.sdk.kotlin.services.timestreamquery.model.UpdateScheduledQueryRequest
import aws.sdk.kotlin.services.timestreamquery.model.UpdateScheduledQueryResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Timestream Query"
public const val SdkVersion: String = "1.3.59"
public const val ServiceApiVersion: String = "2018-11-01"

/**
 * # Amazon Timestream Query
 */
public interface TimestreamQueryClient : SdkClient {
    /**
     * TimestreamQueryClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, TimestreamQueryClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "TimestreamQuery",
                "TIMESTREAM_QUERY",
                "timestream_query",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, TimestreamQueryClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): TimestreamQueryClient = DefaultTimestreamQueryClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointDiscoverer: TimestreamQueryEndpointDiscoverer = builder.endpointDiscoverer ?: TimestreamQueryEndpointDiscoverer()
        public val endpointProvider: TimestreamQueryEndpointProvider = builder.endpointProvider ?: DefaultTimestreamQueryEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: TimestreamQueryAuthSchemeProvider = builder.authSchemeProvider ?: DefaultTimestreamQueryAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointDiscoverer = this@Config.endpointDiscoverer
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Timestream Query"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint discoverer for this client
             */
            public var endpointDiscoverer: TimestreamQueryEndpointDiscoverer? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: TimestreamQueryEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: TimestreamQueryAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels a query that has been issued. Cancellation is provided only if the query has not completed running before the cancellation request was issued. Because cancellation is an idempotent operation, subsequent cancellation requests will return a `CancellationMessage`, indicating that the query has already been canceled. See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.cancel-query.html) for details.
     */
    public suspend fun cancelQuery(input: CancelQueryRequest): CancelQueryResponse

    /**
     * Create a scheduled query that will be run on your behalf at the configured schedule. Timestream assumes the execution role provided as part of the `ScheduledQueryExecutionRoleArn` parameter to run the query. You can use the `NotificationConfiguration` parameter to configure notification for your scheduled query operations.
     */
    public suspend fun createScheduledQuery(input: CreateScheduledQueryRequest): CreateScheduledQueryResponse

    /**
     * Deletes a given scheduled query. This is an irreversible operation.
     */
    public suspend fun deleteScheduledQuery(input: DeleteScheduledQueryRequest): DeleteScheduledQueryResponse

    /**
     * Describes the settings for your account that include the query pricing model and the configured maximum TCUs the service can use for your query workload.
     *
     * You're charged only for the duration of compute units used for your workloads.
     */
    public suspend fun describeAccountSettings(input: DescribeAccountSettingsRequest = DescribeAccountSettingsRequest { }): DescribeAccountSettingsResponse

    /**
     * DescribeEndpoints returns a list of available endpoints to make Timestream API calls against. This API is available through both Write and Query.
     *
     * Because the Timestream SDKs are designed to transparently work with the service’s architecture, including the management and mapping of the service endpoints, *it is not recommended that you use this API unless*:
     * + You are using [VPC endpoints (Amazon Web Services PrivateLink) with Timestream ](https://docs.aws.amazon.com/timestream/latest/developerguide/VPCEndpoints)
     * + Your application uses a programming language that does not yet have SDK support
     * + You require better control over the client-side implementation
     *
     * For detailed information on how and when to use and implement DescribeEndpoints, see [The Endpoint Discovery Pattern](https://docs.aws.amazon.com/timestream/latest/developerguide/Using.API.html#Using-API.endpoint-discovery).
     */
    public suspend fun describeEndpoints(input: DescribeEndpointsRequest = DescribeEndpointsRequest { }): DescribeEndpointsResponse

    /**
     * Provides detailed information about a scheduled query.
     */
    public suspend fun describeScheduledQuery(input: DescribeScheduledQueryRequest): DescribeScheduledQueryResponse

    /**
     * You can use this API to run a scheduled query manually.
     *
     * If you enabled `QueryInsights`, this API also returns insights and metrics related to the query that you executed as part of an Amazon SNS notification. `QueryInsights` helps with performance tuning of your query.
     */
    public suspend fun executeScheduledQuery(input: ExecuteScheduledQueryRequest): ExecuteScheduledQueryResponse

    /**
     * Gets a list of all scheduled queries in the caller's Amazon account and Region. `ListScheduledQueries` is eventually consistent.
     */
    public suspend fun listScheduledQueries(input: ListScheduledQueriesRequest = ListScheduledQueriesRequest { }): ListScheduledQueriesResponse

    /**
     * List all tags on a Timestream query resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * A synchronous operation that allows you to submit a query with parameters to be stored by Timestream for later running. Timestream only supports using this operation with `ValidateOnly` set to `true`.
     */
    public suspend fun prepareQuery(input: PrepareQueryRequest): PrepareQueryResponse

    /**
     * `Query` is a synchronous operation that enables you to run a query against your Amazon Timestream data.
     *
     * If you enabled `QueryInsights`, this API also returns insights and metrics related to the query that you executed. `QueryInsights` helps with performance tuning of your query.
     *
     * The maximum number of `Query` API requests you're allowed to make with `QueryInsights` enabled is 1 query per second (QPS). If you exceed this query rate, it might result in throttling.
     *
     * `Query` will time out after 60 seconds. You must update the default timeout in the SDK to support a timeout of 60 seconds. See the [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.run-query.html) for details.
     *
     * Your query request will fail in the following cases:
     * +  If you submit a `Query` request with the same client token outside of the 5-minute idempotency window.
     * +  If you submit a `Query` request with the same client token, but change other parameters, within the 5-minute idempotency window.
     * +  If the size of the row (including the query metadata) exceeds 1 MB, then the query will fail with the following error message: `Query aborted as max page response size has been exceeded by the output result row`
     * +  If the IAM principal of the query initiator and the result reader are not the same and/or the query initiator and the result reader do not have the same query string in the query requests, the query will fail with an `Invalid pagination token` error.
     */
    public suspend fun query(input: QueryRequest): QueryResponse

    /**
     * Associate a set of tags with a Timestream resource. You can then activate these user-defined tags so that they appear on the Billing and Cost Management console for cost allocation tracking.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the association of tags from a Timestream query resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Transitions your account to use TCUs for query pricing and modifies the maximum query compute units that you've configured. If you reduce the value of `MaxQueryTCU` to a desired configuration, the new value can take up to 24 hours to be effective.
     *
     * After you've transitioned your account to use TCUs for query pricing, you can't transition to using bytes scanned for query pricing.
     */
    public suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest = UpdateAccountSettingsRequest { }): UpdateAccountSettingsResponse

    /**
     * Update a scheduled query.
     */
    public suspend fun updateScheduledQuery(input: UpdateScheduledQueryRequest): UpdateScheduledQueryResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun TimestreamQueryClient.withConfig(block: TimestreamQueryClient.Config.Builder.() -> Unit): TimestreamQueryClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultTimestreamQueryClient(newConfig)
}

/**
 * Cancels a query that has been issued. Cancellation is provided only if the query has not completed running before the cancellation request was issued. Because cancellation is an idempotent operation, subsequent cancellation requests will return a `CancellationMessage`, indicating that the query has already been canceled. See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.cancel-query.html) for details.
 */
public suspend inline fun TimestreamQueryClient.cancelQuery(crossinline block: CancelQueryRequest.Builder.() -> Unit): CancelQueryResponse = cancelQuery(CancelQueryRequest.Builder().apply(block).build())

/**
 * Create a scheduled query that will be run on your behalf at the configured schedule. Timestream assumes the execution role provided as part of the `ScheduledQueryExecutionRoleArn` parameter to run the query. You can use the `NotificationConfiguration` parameter to configure notification for your scheduled query operations.
 */
public suspend inline fun TimestreamQueryClient.createScheduledQuery(crossinline block: CreateScheduledQueryRequest.Builder.() -> Unit): CreateScheduledQueryResponse = createScheduledQuery(CreateScheduledQueryRequest.Builder().apply(block).build())

/**
 * Deletes a given scheduled query. This is an irreversible operation.
 */
public suspend inline fun TimestreamQueryClient.deleteScheduledQuery(crossinline block: DeleteScheduledQueryRequest.Builder.() -> Unit): DeleteScheduledQueryResponse = deleteScheduledQuery(DeleteScheduledQueryRequest.Builder().apply(block).build())

/**
 * Describes the settings for your account that include the query pricing model and the configured maximum TCUs the service can use for your query workload.
 *
 * You're charged only for the duration of compute units used for your workloads.
 */
public suspend inline fun TimestreamQueryClient.describeAccountSettings(crossinline block: DescribeAccountSettingsRequest.Builder.() -> Unit): DescribeAccountSettingsResponse = describeAccountSettings(DescribeAccountSettingsRequest.Builder().apply(block).build())

/**
 * DescribeEndpoints returns a list of available endpoints to make Timestream API calls against. This API is available through both Write and Query.
 *
 * Because the Timestream SDKs are designed to transparently work with the service’s architecture, including the management and mapping of the service endpoints, *it is not recommended that you use this API unless*:
 * + You are using [VPC endpoints (Amazon Web Services PrivateLink) with Timestream ](https://docs.aws.amazon.com/timestream/latest/developerguide/VPCEndpoints)
 * + Your application uses a programming language that does not yet have SDK support
 * + You require better control over the client-side implementation
 *
 * For detailed information on how and when to use and implement DescribeEndpoints, see [The Endpoint Discovery Pattern](https://docs.aws.amazon.com/timestream/latest/developerguide/Using.API.html#Using-API.endpoint-discovery).
 */
public suspend inline fun TimestreamQueryClient.describeEndpoints(crossinline block: DescribeEndpointsRequest.Builder.() -> Unit): DescribeEndpointsResponse = describeEndpoints(DescribeEndpointsRequest.Builder().apply(block).build())

/**
 * Provides detailed information about a scheduled query.
 */
public suspend inline fun TimestreamQueryClient.describeScheduledQuery(crossinline block: DescribeScheduledQueryRequest.Builder.() -> Unit): DescribeScheduledQueryResponse = describeScheduledQuery(DescribeScheduledQueryRequest.Builder().apply(block).build())

/**
 * You can use this API to run a scheduled query manually.
 *
 * If you enabled `QueryInsights`, this API also returns insights and metrics related to the query that you executed as part of an Amazon SNS notification. `QueryInsights` helps with performance tuning of your query.
 */
public suspend inline fun TimestreamQueryClient.executeScheduledQuery(crossinline block: ExecuteScheduledQueryRequest.Builder.() -> Unit): ExecuteScheduledQueryResponse = executeScheduledQuery(ExecuteScheduledQueryRequest.Builder().apply(block).build())

/**
 * Gets a list of all scheduled queries in the caller's Amazon account and Region. `ListScheduledQueries` is eventually consistent.
 */
public suspend inline fun TimestreamQueryClient.listScheduledQueries(crossinline block: ListScheduledQueriesRequest.Builder.() -> Unit): ListScheduledQueriesResponse = listScheduledQueries(ListScheduledQueriesRequest.Builder().apply(block).build())

/**
 * List all tags on a Timestream query resource.
 */
public suspend inline fun TimestreamQueryClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * A synchronous operation that allows you to submit a query with parameters to be stored by Timestream for later running. Timestream only supports using this operation with `ValidateOnly` set to `true`.
 */
public suspend inline fun TimestreamQueryClient.prepareQuery(crossinline block: PrepareQueryRequest.Builder.() -> Unit): PrepareQueryResponse = prepareQuery(PrepareQueryRequest.Builder().apply(block).build())

/**
 * `Query` is a synchronous operation that enables you to run a query against your Amazon Timestream data.
 *
 * If you enabled `QueryInsights`, this API also returns insights and metrics related to the query that you executed. `QueryInsights` helps with performance tuning of your query.
 *
 * The maximum number of `Query` API requests you're allowed to make with `QueryInsights` enabled is 1 query per second (QPS). If you exceed this query rate, it might result in throttling.
 *
 * `Query` will time out after 60 seconds. You must update the default timeout in the SDK to support a timeout of 60 seconds. See the [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.run-query.html) for details.
 *
 * Your query request will fail in the following cases:
 * +  If you submit a `Query` request with the same client token outside of the 5-minute idempotency window.
 * +  If you submit a `Query` request with the same client token, but change other parameters, within the 5-minute idempotency window.
 * +  If the size of the row (including the query metadata) exceeds 1 MB, then the query will fail with the following error message: `Query aborted as max page response size has been exceeded by the output result row`
 * +  If the IAM principal of the query initiator and the result reader are not the same and/or the query initiator and the result reader do not have the same query string in the query requests, the query will fail with an `Invalid pagination token` error.
 */
public suspend inline fun TimestreamQueryClient.query(crossinline block: QueryRequest.Builder.() -> Unit): QueryResponse = query(QueryRequest.Builder().apply(block).build())

/**
 * Associate a set of tags with a Timestream resource. You can then activate these user-defined tags so that they appear on the Billing and Cost Management console for cost allocation tracking.
 */
public suspend inline fun TimestreamQueryClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the association of tags from a Timestream query resource.
 */
public suspend inline fun TimestreamQueryClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Transitions your account to use TCUs for query pricing and modifies the maximum query compute units that you've configured. If you reduce the value of `MaxQueryTCU` to a desired configuration, the new value can take up to 24 hours to be effective.
 *
 * After you've transitioned your account to use TCUs for query pricing, you can't transition to using bytes scanned for query pricing.
 */
public suspend inline fun TimestreamQueryClient.updateAccountSettings(crossinline block: UpdateAccountSettingsRequest.Builder.() -> Unit): UpdateAccountSettingsResponse = updateAccountSettings(UpdateAccountSettingsRequest.Builder().apply(block).build())

/**
 * Update a scheduled query.
 */
public suspend inline fun TimestreamQueryClient.updateScheduledQuery(crossinline block: UpdateScheduledQueryRequest.Builder.() -> Unit): UpdateScheduledQueryResponse = updateScheduledQuery(UpdateScheduledQueryRequest.Builder().apply(block).build())
