// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.paginators

import aws.sdk.kotlin.services.timestreamquery.TimestreamQueryClient
import aws.sdk.kotlin.services.timestreamquery.model.ListScheduledQueriesRequest
import aws.sdk.kotlin.services.timestreamquery.model.ListScheduledQueriesResponse
import aws.sdk.kotlin.services.timestreamquery.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.timestreamquery.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.timestreamquery.model.QueryRequest
import aws.sdk.kotlin.services.timestreamquery.model.QueryResponse
import aws.sdk.kotlin.services.timestreamquery.model.Row
import aws.sdk.kotlin.services.timestreamquery.model.ScheduledQuery
import aws.sdk.kotlin.services.timestreamquery.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListScheduledQueriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListScheduledQueriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScheduledQueriesResponse]
 */
public fun TimestreamQueryClient.listScheduledQueriesPaginated(initialRequest: ListScheduledQueriesRequest = ListScheduledQueriesRequest { }): Flow<ListScheduledQueriesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listScheduledQueriesPaginated.listScheduledQueries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListScheduledQueriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScheduledQueriesResponse]
 */
public fun TimestreamQueryClient.listScheduledQueriesPaginated(block: ListScheduledQueriesRequest.Builder.() -> Unit): Flow<ListScheduledQueriesResponse> =
    listScheduledQueriesPaginated(ListScheduledQueriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listScheduledQueriesPaginated]
 * to access the nested member [ScheduledQuery]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScheduledQuery]
 */
@JvmName("listScheduledQueriesResponseScheduledQuery")
public fun Flow<ListScheduledQueriesResponse>.scheduledQueries(): Flow<ScheduledQuery> =
    transform() { response ->
        response.scheduledQueries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun TimestreamQueryClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun TimestreamQueryClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
public fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [QueryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [QueryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueryResponse]
 */
public fun TimestreamQueryClient.queryPaginated(initialRequest: QueryRequest): Flow<QueryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@queryPaginated.query(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [QueryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueryResponse]
 */
public fun TimestreamQueryClient.queryPaginated(block: QueryRequest.Builder.() -> Unit): Flow<QueryResponse> =
    queryPaginated(QueryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [queryPaginated]
 * to access the nested member [Row]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Row]
 */
@JvmName("queryResponseRow")
public fun Flow<QueryResponse>.rows(): Flow<Row> =
    transform() { response ->
        response.rows?.forEach {
            emit(it)
        }
    }
