// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Structure that describes scheduled query.
 */
public class ScheduledQueryDescription private constructor(builder: Builder) {
    /**
     * Scheduled query ARN.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Creation time of the scheduled query.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Error-reporting configuration for the scheduled query.
     */
    public val errorReportConfiguration: aws.sdk.kotlin.services.timestreamquery.model.ErrorReportConfiguration? = builder.errorReportConfiguration
    /**
     * A customer provided KMS key used to encrypt the scheduled query resource.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Runtime summary for the last scheduled query run.
     */
    public val lastRunSummary: aws.sdk.kotlin.services.timestreamquery.model.ScheduledQueryRunSummary? = builder.lastRunSummary
    /**
     * Name of the scheduled query.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The next time the scheduled query is scheduled to run.
     */
    public val nextInvocationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.nextInvocationTime
    /**
     * Notification configuration.
     */
    public val notificationConfiguration: aws.sdk.kotlin.services.timestreamquery.model.NotificationConfiguration? = builder.notificationConfiguration
    /**
     * Last time the query was run.
     */
    public val previousInvocationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.previousInvocationTime
    /**
     * The query to be run.
     */
    public val queryString: kotlin.String = requireNotNull(builder.queryString) { "A non-null value must be provided for queryString" }
    /**
     * Runtime summary for the last five failed scheduled query runs.
     */
    public val recentlyFailedRuns: List<ScheduledQueryRunSummary>? = builder.recentlyFailedRuns
    /**
     * Schedule configuration.
     */
    public val scheduleConfiguration: aws.sdk.kotlin.services.timestreamquery.model.ScheduleConfiguration? = builder.scheduleConfiguration
    /**
     * IAM role that Timestream uses to run the schedule query.
     */
    public val scheduledQueryExecutionRoleArn: kotlin.String? = builder.scheduledQueryExecutionRoleArn
    /**
     * State of the scheduled query.
     */
    public val state: aws.sdk.kotlin.services.timestreamquery.model.ScheduledQueryState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * Scheduled query target store configuration.
     */
    public val targetConfiguration: aws.sdk.kotlin.services.timestreamquery.model.TargetConfiguration? = builder.targetConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.ScheduledQueryDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledQueryDescription(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("errorReportConfiguration=$errorReportConfiguration,")
        append("kmsKeyId=$kmsKeyId,")
        append("lastRunSummary=$lastRunSummary,")
        append("name=$name,")
        append("nextInvocationTime=$nextInvocationTime,")
        append("notificationConfiguration=$notificationConfiguration,")
        append("previousInvocationTime=$previousInvocationTime,")
        append("queryString=*** Sensitive Data Redacted ***,")
        append("recentlyFailedRuns=$recentlyFailedRuns,")
        append("scheduleConfiguration=$scheduleConfiguration,")
        append("scheduledQueryExecutionRoleArn=$scheduledQueryExecutionRoleArn,")
        append("state=$state,")
        append("targetConfiguration=$targetConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (errorReportConfiguration?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lastRunSummary?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (nextInvocationTime?.hashCode() ?: 0)
        result = 31 * result + (notificationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (previousInvocationTime?.hashCode() ?: 0)
        result = 31 * result + (queryString.hashCode())
        result = 31 * result + (recentlyFailedRuns?.hashCode() ?: 0)
        result = 31 * result + (scheduleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (scheduledQueryExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (state.hashCode())
        result = 31 * result + (targetConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledQueryDescription

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (errorReportConfiguration != other.errorReportConfiguration) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lastRunSummary != other.lastRunSummary) return false
        if (name != other.name) return false
        if (nextInvocationTime != other.nextInvocationTime) return false
        if (notificationConfiguration != other.notificationConfiguration) return false
        if (previousInvocationTime != other.previousInvocationTime) return false
        if (queryString != other.queryString) return false
        if (recentlyFailedRuns != other.recentlyFailedRuns) return false
        if (scheduleConfiguration != other.scheduleConfiguration) return false
        if (scheduledQueryExecutionRoleArn != other.scheduledQueryExecutionRoleArn) return false
        if (state != other.state) return false
        if (targetConfiguration != other.targetConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.ScheduledQueryDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Scheduled query ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * Creation time of the scheduled query.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Error-reporting configuration for the scheduled query.
         */
        public var errorReportConfiguration: aws.sdk.kotlin.services.timestreamquery.model.ErrorReportConfiguration? = null
        /**
         * A customer provided KMS key used to encrypt the scheduled query resource.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Runtime summary for the last scheduled query run.
         */
        public var lastRunSummary: aws.sdk.kotlin.services.timestreamquery.model.ScheduledQueryRunSummary? = null
        /**
         * Name of the scheduled query.
         */
        public var name: kotlin.String? = null
        /**
         * The next time the scheduled query is scheduled to run.
         */
        public var nextInvocationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Notification configuration.
         */
        public var notificationConfiguration: aws.sdk.kotlin.services.timestreamquery.model.NotificationConfiguration? = null
        /**
         * Last time the query was run.
         */
        public var previousInvocationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The query to be run.
         */
        public var queryString: kotlin.String? = null
        /**
         * Runtime summary for the last five failed scheduled query runs.
         */
        public var recentlyFailedRuns: List<ScheduledQueryRunSummary>? = null
        /**
         * Schedule configuration.
         */
        public var scheduleConfiguration: aws.sdk.kotlin.services.timestreamquery.model.ScheduleConfiguration? = null
        /**
         * IAM role that Timestream uses to run the schedule query.
         */
        public var scheduledQueryExecutionRoleArn: kotlin.String? = null
        /**
         * State of the scheduled query.
         */
        public var state: aws.sdk.kotlin.services.timestreamquery.model.ScheduledQueryState? = null
        /**
         * Scheduled query target store configuration.
         */
        public var targetConfiguration: aws.sdk.kotlin.services.timestreamquery.model.TargetConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.ScheduledQueryDescription) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.errorReportConfiguration = x.errorReportConfiguration
            this.kmsKeyId = x.kmsKeyId
            this.lastRunSummary = x.lastRunSummary
            this.name = x.name
            this.nextInvocationTime = x.nextInvocationTime
            this.notificationConfiguration = x.notificationConfiguration
            this.previousInvocationTime = x.previousInvocationTime
            this.queryString = x.queryString
            this.recentlyFailedRuns = x.recentlyFailedRuns
            this.scheduleConfiguration = x.scheduleConfiguration
            this.scheduledQueryExecutionRoleArn = x.scheduledQueryExecutionRoleArn
            this.state = x.state
            this.targetConfiguration = x.targetConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.ScheduledQueryDescription = ScheduledQueryDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.ErrorReportConfiguration] inside the given [block]
         */
        public fun errorReportConfiguration(block: aws.sdk.kotlin.services.timestreamquery.model.ErrorReportConfiguration.Builder.() -> kotlin.Unit) {
            this.errorReportConfiguration = aws.sdk.kotlin.services.timestreamquery.model.ErrorReportConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.ScheduledQueryRunSummary] inside the given [block]
         */
        public fun lastRunSummary(block: aws.sdk.kotlin.services.timestreamquery.model.ScheduledQueryRunSummary.Builder.() -> kotlin.Unit) {
            this.lastRunSummary = aws.sdk.kotlin.services.timestreamquery.model.ScheduledQueryRunSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.NotificationConfiguration] inside the given [block]
         */
        public fun notificationConfiguration(block: aws.sdk.kotlin.services.timestreamquery.model.NotificationConfiguration.Builder.() -> kotlin.Unit) {
            this.notificationConfiguration = aws.sdk.kotlin.services.timestreamquery.model.NotificationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.ScheduleConfiguration] inside the given [block]
         */
        public fun scheduleConfiguration(block: aws.sdk.kotlin.services.timestreamquery.model.ScheduleConfiguration.Builder.() -> kotlin.Unit) {
            this.scheduleConfiguration = aws.sdk.kotlin.services.timestreamquery.model.ScheduleConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.TargetConfiguration] inside the given [block]
         */
        public fun targetConfiguration(block: aws.sdk.kotlin.services.timestreamquery.model.TargetConfiguration.Builder.() -> kotlin.Unit) {
            this.targetConfiguration = aws.sdk.kotlin.services.timestreamquery.model.TargetConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (name == null) name = ""
            if (queryString == null) queryString = ""
            if (state == null) state = ScheduledQueryState.SdkUnknown("no value provided")
            return this
        }
    }
}
