// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the status of the query, including progress and bytes scanned.
 */
public class QueryStatus private constructor(builder: Builder) {
    /**
     * The amount of data scanned by the query in bytes that you will be charged for. This is a cumulative sum and represents the total amount of data that you will be charged for since the query was started. The charge is applied only once and is either applied when the query completes running or when the query is cancelled.
     */
    public val cumulativeBytesMetered: kotlin.Long = builder.cumulativeBytesMetered
    /**
     * The amount of data scanned by the query in bytes. This is a cumulative sum and represents the total amount of bytes scanned since the query was started.
     */
    public val cumulativeBytesScanned: kotlin.Long = builder.cumulativeBytesScanned
    /**
     * The progress of the query, expressed as a percentage.
     */
    public val progressPercentage: kotlin.Double = builder.progressPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.QueryStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryStatus(")
        append("cumulativeBytesMetered=$cumulativeBytesMetered,")
        append("cumulativeBytesScanned=$cumulativeBytesScanned,")
        append("progressPercentage=$progressPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cumulativeBytesMetered.hashCode()
        result = 31 * result + (cumulativeBytesScanned.hashCode())
        result = 31 * result + (progressPercentage.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryStatus

        if (cumulativeBytesMetered != other.cumulativeBytesMetered) return false
        if (cumulativeBytesScanned != other.cumulativeBytesScanned) return false
        if (!(progressPercentage?.equals(other.progressPercentage) ?: (other.progressPercentage == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.QueryStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of data scanned by the query in bytes that you will be charged for. This is a cumulative sum and represents the total amount of data that you will be charged for since the query was started. The charge is applied only once and is either applied when the query completes running or when the query is cancelled.
         */
        public var cumulativeBytesMetered: kotlin.Long = 0L
        /**
         * The amount of data scanned by the query in bytes. This is a cumulative sum and represents the total amount of bytes scanned since the query was started.
         */
        public var cumulativeBytesScanned: kotlin.Long = 0L
        /**
         * The progress of the query, expressed as a percentage.
         */
        public var progressPercentage: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.QueryStatus) : this() {
            this.cumulativeBytesMetered = x.cumulativeBytesMetered
            this.cumulativeBytesScanned = x.cumulativeBytesScanned
            this.progressPercentage = x.progressPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.QueryStatus = QueryStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
