// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.serde

import aws.sdk.kotlin.services.timestreamquery.model.QueryPricingModel
import aws.sdk.kotlin.services.timestreamquery.model.TimestreamQueryException
import aws.sdk.kotlin.services.timestreamquery.model.UpdateAccountSettingsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAccountSettingsOperationDeserializer: HttpDeserializer.NonStreaming<UpdateAccountSettingsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateAccountSettingsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateAccountSettingsError(context, call, payload)
        }
        val builder = UpdateAccountSettingsResponse.Builder()

        if (payload != null) {
            deserializeUpdateAccountSettingsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateAccountSettingsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TimestreamQueryException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEndpointException" -> InvalidEndpointExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TimestreamQueryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateAccountSettingsOperationBody(builder: UpdateAccountSettingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MAXQUERYTCU_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxQueryTCU"))
    val QUERYPRICINGMODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("QueryPricingModel"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MAXQUERYTCU_DESCRIPTOR)
        field(QUERYPRICINGMODEL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MAXQUERYTCU_DESCRIPTOR.index -> builder.maxQueryTcu = deserializeInt()
                QUERYPRICINGMODEL_DESCRIPTOR.index -> builder.queryPricingModel = deserializeString().let { QueryPricingModel.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
