// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.serde

import aws.sdk.kotlin.services.timestreamquery.model.ParameterMapping
import aws.sdk.kotlin.services.timestreamquery.model.PrepareQueryResponse
import aws.sdk.kotlin.services.timestreamquery.model.SelectColumn
import aws.sdk.kotlin.services.timestreamquery.model.TimestreamQueryException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class PrepareQueryOperationDeserializer: HttpDeserializer.NonStreaming<PrepareQueryResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PrepareQueryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPrepareQueryError(context, call, payload)
        }
        val builder = PrepareQueryResponse.Builder()

        if (payload != null) {
            deserializePrepareQueryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPrepareQueryError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TimestreamQueryException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEndpointException" -> InvalidEndpointExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TimestreamQueryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePrepareQueryOperationBody(builder: PrepareQueryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COLUMNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Columns"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Parameters"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryString"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLUMNS_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COLUMNS_DESCRIPTOR.index -> builder.columns =
                    deserializer.deserializeList(COLUMNS_DESCRIPTOR) {
                        val col0 = mutableListOf<SelectColumn>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSelectColumnDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PARAMETERS_DESCRIPTOR.index -> builder.parameters =
                    deserializer.deserializeList(PARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<ParameterMapping>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeParameterMappingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                QUERYSTRING_DESCRIPTOR.index -> builder.queryString = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
