// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The timeseries data type represents the values of a measure over time. A time series is an array of rows of timestamps and measure values, with rows sorted in ascending order of time. A TimeSeriesDataPoint is a single data point in the time series. It represents a tuple of (time, measure value) in a time series.
 */
public class TimeSeriesDataPoint private constructor(builder: Builder) {
    /**
     * The timestamp when the measure value was collected.
     */
    public val time: kotlin.String = requireNotNull(builder.time) { "A non-null value must be provided for time" }
    /**
     * The measure value for the data point.
     */
    public val value: aws.sdk.kotlin.services.timestreamquery.model.Datum? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.TimeSeriesDataPoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeSeriesDataPoint(")
        append("time=$time,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = time.hashCode()
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeSeriesDataPoint

        if (time != other.time) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.TimeSeriesDataPoint = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp when the measure value was collected.
         */
        public var time: kotlin.String? = null
        /**
         * The measure value for the data point.
         */
        public var value: aws.sdk.kotlin.services.timestreamquery.model.Datum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.TimeSeriesDataPoint) : this() {
            this.time = x.time
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.TimeSeriesDataPoint = TimeSeriesDataPoint(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.Datum] inside the given [block]
         */
        public fun value(block: aws.sdk.kotlin.services.timestreamquery.model.Datum.Builder.() -> kotlin.Unit) {
            this.value = aws.sdk.kotlin.services.timestreamquery.model.Datum.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (time == null) time = ""
            return this
        }
    }
}
