// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model

import aws.smithy.kotlin.runtime.SdkDsl

public class QueryRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive string of up to 64 ASCII characters specified when a `Query` request is made. Providing a `ClientToken` makes the call to `Query`*idempotent*. This means that running the same query repeatedly will produce the same result. In other words, making multiple identical `Query` requests has the same effect as making a single request. When using `ClientToken` in a query, note the following:
     * +  If the Query API is instantiated without a `ClientToken`, the Query SDK generates a `ClientToken` on your behalf.
     * + If the `Query` invocation only contains the `ClientToken` but does not include a `NextToken`, that invocation of `Query` is assumed to be a new query run.
     * + If the invocation contains `NextToken`, that particular invocation is assumed to be a subsequent invocation of a prior call to the Query API, and a result set is returned.
     * +  After 4 hours, any request with the same `ClientToken` is treated as a new request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The total number of rows to be returned in the `Query` output. The initial run of `Query` with a `MaxRows` value specified will return the result set of the query in two cases:
     * + The size of the result is less than `1MB`.
     * + The number of rows in the result set is less than the value of `maxRows`.
     *
     * Otherwise, the initial invocation of `Query` only returns a `NextToken`, which can then be used in subsequent calls to fetch the result set. To resume pagination, provide the `NextToken` value in the subsequent command.
     *
     * If the row size is large (e.g. a row has many columns), Timestream may return fewer rows to keep the response size from exceeding the 1 MB limit. If `MaxRows` is not provided, Timestream will send the necessary number of rows to meet the 1 MB limit.
     */
    public val maxRows: kotlin.Int? = builder.maxRows
    /**
     * A pagination token used to return a set of results. When the `Query` API is invoked using `NextToken`, that particular invocation is assumed to be a subsequent invocation of a prior call to `Query`, and a result set is returned. However, if the `Query` invocation only contains the `ClientToken`, that invocation of `Query` is assumed to be a new query run.
     *
     * Note the following when using NextToken in a query:
     * + A pagination token can be used for up to five `Query` invocations, OR for a duration of up to 1 hour – whichever comes first.
     * + Using the same `NextToken` will return the same set of records. To keep paginating through the result set, you must to use the most recent `nextToken`.
     * + Suppose a `Query` invocation returns two `NextToken` values, `TokenA` and `TokenB`. If `TokenB` is used in a subsequent `Query` invocation, then `TokenA` is invalidated and cannot be reused.
     * + To request a previous result set from a query after pagination has begun, you must re-invoke the Query API.
     * + The latest `NextToken` should be used to paginate until `null` is returned, at which point a new `NextToken` should be used.
     * +  If the IAM principal of the query initiator and the result reader are not the same and/or the query initiator and the result reader do not have the same query string in the query requests, the query will fail with an `Invalid pagination token` error.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The query to be run by Timestream.
     */
    public val queryString: kotlin.String? = builder.queryString

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.QueryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryRequest(")
        append("clientToken=*** Sensitive Data Redacted ***,")
        append("maxRows=$maxRows,")
        append("nextToken=$nextToken,")
        append("queryString=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (maxRows ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryRequest

        if (clientToken != other.clientToken) return false
        if (maxRows != other.maxRows) return false
        if (nextToken != other.nextToken) return false
        if (queryString != other.queryString) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.QueryRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Unique, case-sensitive string of up to 64 ASCII characters specified when a `Query` request is made. Providing a `ClientToken` makes the call to `Query`*idempotent*. This means that running the same query repeatedly will produce the same result. In other words, making multiple identical `Query` requests has the same effect as making a single request. When using `ClientToken` in a query, note the following:
         * +  If the Query API is instantiated without a `ClientToken`, the Query SDK generates a `ClientToken` on your behalf.
         * + If the `Query` invocation only contains the `ClientToken` but does not include a `NextToken`, that invocation of `Query` is assumed to be a new query run.
         * + If the invocation contains `NextToken`, that particular invocation is assumed to be a subsequent invocation of a prior call to the Query API, and a result set is returned.
         * +  After 4 hours, any request with the same `ClientToken` is treated as a new request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The total number of rows to be returned in the `Query` output. The initial run of `Query` with a `MaxRows` value specified will return the result set of the query in two cases:
         * + The size of the result is less than `1MB`.
         * + The number of rows in the result set is less than the value of `maxRows`.
         *
         * Otherwise, the initial invocation of `Query` only returns a `NextToken`, which can then be used in subsequent calls to fetch the result set. To resume pagination, provide the `NextToken` value in the subsequent command.
         *
         * If the row size is large (e.g. a row has many columns), Timestream may return fewer rows to keep the response size from exceeding the 1 MB limit. If `MaxRows` is not provided, Timestream will send the necessary number of rows to meet the 1 MB limit.
         */
        public var maxRows: kotlin.Int? = null
        /**
         * A pagination token used to return a set of results. When the `Query` API is invoked using `NextToken`, that particular invocation is assumed to be a subsequent invocation of a prior call to `Query`, and a result set is returned. However, if the `Query` invocation only contains the `ClientToken`, that invocation of `Query` is assumed to be a new query run.
         *
         * Note the following when using NextToken in a query:
         * + A pagination token can be used for up to five `Query` invocations, OR for a duration of up to 1 hour – whichever comes first.
         * + Using the same `NextToken` will return the same set of records. To keep paginating through the result set, you must to use the most recent `nextToken`.
         * + Suppose a `Query` invocation returns two `NextToken` values, `TokenA` and `TokenB`. If `TokenB` is used in a subsequent `Query` invocation, then `TokenA` is invalidated and cannot be reused.
         * + To request a previous result set from a query after pagination has begun, you must re-invoke the Query API.
         * + The latest `NextToken` should be used to paginate until `null` is returned, at which point a new `NextToken` should be used.
         * +  If the IAM principal of the query initiator and the result reader are not the same and/or the query initiator and the result reader do not have the same query string in the query requests, the query will fail with an `Invalid pagination token` error.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The query to be run by Timestream.
         */
        public var queryString: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.QueryRequest) : this() {
            this.clientToken = x.clientToken
            this.maxRows = x.maxRows
            this.nextToken = x.nextToken
            this.queryString = x.queryString
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.QueryRequest = QueryRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
