// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model



/**
 * Configuration to write data into Timestream database and table. This configuration allows the user to map the query result select columns into the destination table columns.
 */
public class TimestreamConfiguration private constructor(builder: Builder) {
    /**
     * Name of Timestream database to which the query result will be written.
     */
    public val databaseName: kotlin.String = requireNotNull(builder.databaseName) { "A non-null value must be provided for databaseName" }
    /**
     * This is to allow mapping column(s) from the query result to the dimension in the destination table.
     */
    public val dimensionMappings: List<DimensionMapping> = requireNotNull(builder.dimensionMappings) { "A non-null value must be provided for dimensionMappings" }
    /**
     * Name of the measure column.
     */
    public val measureNameColumn: kotlin.String? = builder.measureNameColumn
    /**
     * Specifies how to map measures to multi-measure records.
     */
    public val mixedMeasureMappings: List<MixedMeasureMapping>? = builder.mixedMeasureMappings
    /**
     * Multi-measure mappings.
     */
    public val multiMeasureMappings: aws.sdk.kotlin.services.timestreamquery.model.MultiMeasureMappings? = builder.multiMeasureMappings
    /**
     * Name of Timestream table that the query result will be written to. The table should be within the same database that is provided in Timestream configuration.
     */
    public val tableName: kotlin.String = requireNotNull(builder.tableName) { "A non-null value must be provided for tableName" }
    /**
     * Column from query result that should be used as the time column in destination table. Column type for this should be TIMESTAMP.
     */
    public val timeColumn: kotlin.String = requireNotNull(builder.timeColumn) { "A non-null value must be provided for timeColumn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.TimestreamConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimestreamConfiguration(")
        append("databaseName=$databaseName,")
        append("dimensionMappings=$dimensionMappings,")
        append("measureNameColumn=$measureNameColumn,")
        append("mixedMeasureMappings=$mixedMeasureMappings,")
        append("multiMeasureMappings=$multiMeasureMappings,")
        append("tableName=$tableName,")
        append("timeColumn=$timeColumn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseName.hashCode()
        result = 31 * result + (dimensionMappings.hashCode())
        result = 31 * result + (measureNameColumn?.hashCode() ?: 0)
        result = 31 * result + (mixedMeasureMappings?.hashCode() ?: 0)
        result = 31 * result + (multiMeasureMappings?.hashCode() ?: 0)
        result = 31 * result + (tableName.hashCode())
        result = 31 * result + (timeColumn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimestreamConfiguration

        if (databaseName != other.databaseName) return false
        if (dimensionMappings != other.dimensionMappings) return false
        if (measureNameColumn != other.measureNameColumn) return false
        if (mixedMeasureMappings != other.mixedMeasureMappings) return false
        if (multiMeasureMappings != other.multiMeasureMappings) return false
        if (tableName != other.tableName) return false
        if (timeColumn != other.timeColumn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.TimestreamConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Name of Timestream database to which the query result will be written.
         */
        public var databaseName: kotlin.String? = null
        /**
         * This is to allow mapping column(s) from the query result to the dimension in the destination table.
         */
        public var dimensionMappings: List<DimensionMapping>? = null
        /**
         * Name of the measure column.
         */
        public var measureNameColumn: kotlin.String? = null
        /**
         * Specifies how to map measures to multi-measure records.
         */
        public var mixedMeasureMappings: List<MixedMeasureMapping>? = null
        /**
         * Multi-measure mappings.
         */
        public var multiMeasureMappings: aws.sdk.kotlin.services.timestreamquery.model.MultiMeasureMappings? = null
        /**
         * Name of Timestream table that the query result will be written to. The table should be within the same database that is provided in Timestream configuration.
         */
        public var tableName: kotlin.String? = null
        /**
         * Column from query result that should be used as the time column in destination table. Column type for this should be TIMESTAMP.
         */
        public var timeColumn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.TimestreamConfiguration) : this() {
            this.databaseName = x.databaseName
            this.dimensionMappings = x.dimensionMappings
            this.measureNameColumn = x.measureNameColumn
            this.mixedMeasureMappings = x.mixedMeasureMappings
            this.multiMeasureMappings = x.multiMeasureMappings
            this.tableName = x.tableName
            this.timeColumn = x.timeColumn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.TimestreamConfiguration = TimestreamConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.MultiMeasureMappings] inside the given [block]
         */
        public fun multiMeasureMappings(block: aws.sdk.kotlin.services.timestreamquery.model.MultiMeasureMappings.Builder.() -> kotlin.Unit) {
            this.multiMeasureMappings = aws.sdk.kotlin.services.timestreamquery.model.MultiMeasureMappings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (databaseName == null) databaseName = ""
            if (dimensionMappings == null) dimensionMappings = emptyList()
            if (tableName == null) tableName = ""
            if (timeColumn == null) timeColumn = ""
            return this
        }
    }
}
