// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model



public class CreateScheduledQueryRequest private constructor(builder: Builder) {
    /**
     * Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result. Making multiple identical CreateScheduledQuery requests has the same effect as making a single request.
     * +  If CreateScheduledQuery is called without a `ClientToken`, the Query SDK generates a `ClientToken` on your behalf.
     * +  After 8 hours, any request with the same `ClientToken` is treated as a new request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
     */
    public val errorReportConfiguration: aws.sdk.kotlin.services.timestreamquery.model.ErrorReportConfiguration? = builder.errorReportConfiguration
    /**
     * The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with *alias&#47;*
     *
     * If ErrorReportConfiguration uses `SSE_KMS` as encryption type, the same KmsKeyId is used to encrypt the error report at rest.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Name of the scheduled query.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
     */
    public val notificationConfiguration: aws.sdk.kotlin.services.timestreamquery.model.NotificationConfiguration? = builder.notificationConfiguration
    /**
     * The query string to run. Parameter names can be specified in the query string `@` character followed by an identifier. The named Parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run.
     *
     * The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
     */
    public val queryString: kotlin.String? = builder.queryString
    /**
     * The schedule configuration for the query.
     */
    public val scheduleConfiguration: aws.sdk.kotlin.services.timestreamquery.model.ScheduleConfiguration? = builder.scheduleConfiguration
    /**
     * The ARN for the IAM role that Timestream will assume when running the scheduled query.
     */
    public val scheduledQueryExecutionRoleArn: kotlin.String? = builder.scheduledQueryExecutionRoleArn
    /**
     * A list of key-value pairs to label the scheduled query.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Configuration used for writing the result of a query.
     */
    public val targetConfiguration: aws.sdk.kotlin.services.timestreamquery.model.TargetConfiguration? = builder.targetConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.CreateScheduledQueryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateScheduledQueryRequest(")
        append("clientToken=*** Sensitive Data Redacted ***,")
        append("errorReportConfiguration=$errorReportConfiguration,")
        append("kmsKeyId=$kmsKeyId,")
        append("name=$name,")
        append("notificationConfiguration=$notificationConfiguration,")
        append("queryString=*** Sensitive Data Redacted ***,")
        append("scheduleConfiguration=$scheduleConfiguration,")
        append("scheduledQueryExecutionRoleArn=$scheduledQueryExecutionRoleArn,")
        append("tags=$tags,")
        append("targetConfiguration=$targetConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (errorReportConfiguration?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notificationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (scheduleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (scheduledQueryExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateScheduledQueryRequest

        if (clientToken != other.clientToken) return false
        if (errorReportConfiguration != other.errorReportConfiguration) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (name != other.name) return false
        if (notificationConfiguration != other.notificationConfiguration) return false
        if (queryString != other.queryString) return false
        if (scheduleConfiguration != other.scheduleConfiguration) return false
        if (scheduledQueryExecutionRoleArn != other.scheduledQueryExecutionRoleArn) return false
        if (tags != other.tags) return false
        if (targetConfiguration != other.targetConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.CreateScheduledQueryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result. Making multiple identical CreateScheduledQuery requests has the same effect as making a single request.
         * +  If CreateScheduledQuery is called without a `ClientToken`, the Query SDK generates a `ClientToken` on your behalf.
         * +  After 8 hours, any request with the same `ClientToken` is treated as a new request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
         */
        public var errorReportConfiguration: aws.sdk.kotlin.services.timestreamquery.model.ErrorReportConfiguration? = null
        /**
         * The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with *alias&#47;*
         *
         * If ErrorReportConfiguration uses `SSE_KMS` as encryption type, the same KmsKeyId is used to encrypt the error report at rest.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Name of the scheduled query.
         */
        public var name: kotlin.String? = null
        /**
         * Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
         */
        public var notificationConfiguration: aws.sdk.kotlin.services.timestreamquery.model.NotificationConfiguration? = null
        /**
         * The query string to run. Parameter names can be specified in the query string `@` character followed by an identifier. The named Parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run.
         *
         * The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
         */
        public var queryString: kotlin.String? = null
        /**
         * The schedule configuration for the query.
         */
        public var scheduleConfiguration: aws.sdk.kotlin.services.timestreamquery.model.ScheduleConfiguration? = null
        /**
         * The ARN for the IAM role that Timestream will assume when running the scheduled query.
         */
        public var scheduledQueryExecutionRoleArn: kotlin.String? = null
        /**
         * A list of key-value pairs to label the scheduled query.
         */
        public var tags: List<Tag>? = null
        /**
         * Configuration used for writing the result of a query.
         */
        public var targetConfiguration: aws.sdk.kotlin.services.timestreamquery.model.TargetConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.CreateScheduledQueryRequest) : this() {
            this.clientToken = x.clientToken
            this.errorReportConfiguration = x.errorReportConfiguration
            this.kmsKeyId = x.kmsKeyId
            this.name = x.name
            this.notificationConfiguration = x.notificationConfiguration
            this.queryString = x.queryString
            this.scheduleConfiguration = x.scheduleConfiguration
            this.scheduledQueryExecutionRoleArn = x.scheduledQueryExecutionRoleArn
            this.tags = x.tags
            this.targetConfiguration = x.targetConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.CreateScheduledQueryRequest = CreateScheduledQueryRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.ErrorReportConfiguration] inside the given [block]
         */
        public fun errorReportConfiguration(block: aws.sdk.kotlin.services.timestreamquery.model.ErrorReportConfiguration.Builder.() -> kotlin.Unit) {
            this.errorReportConfiguration = aws.sdk.kotlin.services.timestreamquery.model.ErrorReportConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.NotificationConfiguration] inside the given [block]
         */
        public fun notificationConfiguration(block: aws.sdk.kotlin.services.timestreamquery.model.NotificationConfiguration.Builder.() -> kotlin.Unit) {
            this.notificationConfiguration = aws.sdk.kotlin.services.timestreamquery.model.NotificationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.ScheduleConfiguration] inside the given [block]
         */
        public fun scheduleConfiguration(block: aws.sdk.kotlin.services.timestreamquery.model.ScheduleConfiguration.Builder.() -> kotlin.Unit) {
            this.scheduleConfiguration = aws.sdk.kotlin.services.timestreamquery.model.ScheduleConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.TargetConfiguration] inside the given [block]
         */
        public fun targetConfiguration(block: aws.sdk.kotlin.services.timestreamquery.model.TargetConfiguration.Builder.() -> kotlin.Unit) {
            this.targetConfiguration = aws.sdk.kotlin.services.timestreamquery.model.TargetConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
