// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreaminfluxdb.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetDbClusterResponse private constructor(builder: Builder) {
    /**
     * The amount of storage allocated for your DB storage type (in gibibytes).
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The Amazon Resource Name (ARN) of the DB cluster.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The Timestream for InfluxDB instance type that InfluxDB runs on.
     */
    public val dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = builder.dbInstanceType
    /**
     * The ID of the DB parameter group assigned to your DB cluster.
     */
    public val dbParameterGroupIdentifier: kotlin.String? = builder.dbParameterGroupIdentifier
    /**
     * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     */
    public val dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = builder.dbStorageType
    /**
     * Deployment type of the DB cluster.
     */
    public val deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.ClusterDeploymentType? = builder.deploymentType
    /**
     * The endpoint used to connect to the Timestream for InfluxDB cluster for write and read operations.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The configured failover mode for the DB cluster.
     */
    public val failoverMode: aws.sdk.kotlin.services.timestreaminfluxdb.model.FailoverMode? = builder.failoverMode
    /**
     * Service-generated unique identifier of the DB cluster to retrieve.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The Amazon Resource Name (ARN) of the Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password.
     */
    public val influxAuthParametersSecretArn: kotlin.String? = builder.influxAuthParametersSecretArn
    /**
     * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
     */
    public val logDeliveryConfiguration: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration? = builder.logDeliveryConfiguration
    /**
     * Customer-supplied name of the Timestream for InfluxDB cluster.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     */
    public val networkType: aws.sdk.kotlin.services.timestreaminfluxdb.model.NetworkType? = builder.networkType
    /**
     * The port number on which InfluxDB accepts connections.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * Indicates if the DB cluster has a public IP to facilitate access from outside the VPC.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The endpoint used to connect to the Timestream for InfluxDB cluster for read-only operations.
     */
    public val readerEndpoint: kotlin.String? = builder.readerEndpoint
    /**
     * The status of the DB cluster.
     */
    public val status: aws.sdk.kotlin.services.timestreaminfluxdb.model.ClusterStatus? = builder.status
    /**
     * A list of VPC security group IDs associated with the DB cluster.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds
    /**
     * A list of VPC subnet IDs associated with the DB cluster.
     */
    public val vpcSubnetIds: List<String>? = builder.vpcSubnetIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreaminfluxdb.model.GetDbClusterResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDbClusterResponse(")
        append("allocatedStorage=$allocatedStorage,")
        append("arn=$arn,")
        append("dbInstanceType=$dbInstanceType,")
        append("dbParameterGroupIdentifier=$dbParameterGroupIdentifier,")
        append("dbStorageType=$dbStorageType,")
        append("deploymentType=$deploymentType,")
        append("endpoint=$endpoint,")
        append("failoverMode=$failoverMode,")
        append("id=$id,")
        append("influxAuthParametersSecretArn=$influxAuthParametersSecretArn,")
        append("logDeliveryConfiguration=$logDeliveryConfiguration,")
        append("name=$name,")
        append("networkType=$networkType,")
        append("port=$port,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("readerEndpoint=$readerEndpoint,")
        append("status=$status,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds,")
        append("vpcSubnetIds=$vpcSubnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (dbInstanceType?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbStorageType?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (failoverMode?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (influxAuthParametersSecretArn?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (readerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (vpcSubnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDbClusterResponse

        if (allocatedStorage != other.allocatedStorage) return false
        if (arn != other.arn) return false
        if (dbInstanceType != other.dbInstanceType) return false
        if (dbParameterGroupIdentifier != other.dbParameterGroupIdentifier) return false
        if (dbStorageType != other.dbStorageType) return false
        if (deploymentType != other.deploymentType) return false
        if (endpoint != other.endpoint) return false
        if (failoverMode != other.failoverMode) return false
        if (id != other.id) return false
        if (influxAuthParametersSecretArn != other.influxAuthParametersSecretArn) return false
        if (logDeliveryConfiguration != other.logDeliveryConfiguration) return false
        if (name != other.name) return false
        if (networkType != other.networkType) return false
        if (port != other.port) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (readerEndpoint != other.readerEndpoint) return false
        if (status != other.status) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false
        if (vpcSubnetIds != other.vpcSubnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreaminfluxdb.model.GetDbClusterResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of storage allocated for your DB storage type (in gibibytes).
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the DB cluster.
         */
        public var arn: kotlin.String? = null
        /**
         * The Timestream for InfluxDB instance type that InfluxDB runs on.
         */
        public var dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = null
        /**
         * The ID of the DB parameter group assigned to your DB cluster.
         */
        public var dbParameterGroupIdentifier: kotlin.String? = null
        /**
         * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         */
        public var dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = null
        /**
         * Deployment type of the DB cluster.
         */
        public var deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.ClusterDeploymentType? = null
        /**
         * The endpoint used to connect to the Timestream for InfluxDB cluster for write and read operations.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The configured failover mode for the DB cluster.
         */
        public var failoverMode: aws.sdk.kotlin.services.timestreaminfluxdb.model.FailoverMode? = null
        /**
         * Service-generated unique identifier of the DB cluster to retrieve.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password.
         */
        public var influxAuthParametersSecretArn: kotlin.String? = null
        /**
         * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         */
        public var logDeliveryConfiguration: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration? = null
        /**
         * Customer-supplied name of the Timestream for InfluxDB cluster.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         */
        public var networkType: aws.sdk.kotlin.services.timestreaminfluxdb.model.NetworkType? = null
        /**
         * The port number on which InfluxDB accepts connections.
         */
        public var port: kotlin.Int? = null
        /**
         * Indicates if the DB cluster has a public IP to facilitate access from outside the VPC.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The endpoint used to connect to the Timestream for InfluxDB cluster for read-only operations.
         */
        public var readerEndpoint: kotlin.String? = null
        /**
         * The status of the DB cluster.
         */
        public var status: aws.sdk.kotlin.services.timestreaminfluxdb.model.ClusterStatus? = null
        /**
         * A list of VPC security group IDs associated with the DB cluster.
         */
        public var vpcSecurityGroupIds: List<String>? = null
        /**
         * A list of VPC subnet IDs associated with the DB cluster.
         */
        public var vpcSubnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreaminfluxdb.model.GetDbClusterResponse) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.arn = x.arn
            this.dbInstanceType = x.dbInstanceType
            this.dbParameterGroupIdentifier = x.dbParameterGroupIdentifier
            this.dbStorageType = x.dbStorageType
            this.deploymentType = x.deploymentType
            this.endpoint = x.endpoint
            this.failoverMode = x.failoverMode
            this.id = x.id
            this.influxAuthParametersSecretArn = x.influxAuthParametersSecretArn
            this.logDeliveryConfiguration = x.logDeliveryConfiguration
            this.name = x.name
            this.networkType = x.networkType
            this.port = x.port
            this.publiclyAccessible = x.publiclyAccessible
            this.readerEndpoint = x.readerEndpoint
            this.status = x.status
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
            this.vpcSubnetIds = x.vpcSubnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreaminfluxdb.model.GetDbClusterResponse = GetDbClusterResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration] inside the given [block]
         */
        public fun logDeliveryConfiguration(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration.Builder.() -> kotlin.Unit) {
            this.logDeliveryConfiguration = aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
