// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreaminfluxdb.paginators

import aws.sdk.kotlin.services.timestreaminfluxdb.TimestreamInfluxDbClient
import aws.sdk.kotlin.services.timestreaminfluxdb.model.DbClusterSummary
import aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceForClusterSummary
import aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceSummary
import aws.sdk.kotlin.services.timestreaminfluxdb.model.DbParameterGroupSummary
import aws.sdk.kotlin.services.timestreaminfluxdb.model.ListDbClustersRequest
import aws.sdk.kotlin.services.timestreaminfluxdb.model.ListDbClustersResponse
import aws.sdk.kotlin.services.timestreaminfluxdb.model.ListDbInstancesForClusterRequest
import aws.sdk.kotlin.services.timestreaminfluxdb.model.ListDbInstancesForClusterResponse
import aws.sdk.kotlin.services.timestreaminfluxdb.model.ListDbInstancesRequest
import aws.sdk.kotlin.services.timestreaminfluxdb.model.ListDbInstancesResponse
import aws.sdk.kotlin.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest
import aws.sdk.kotlin.services.timestreaminfluxdb.model.ListDbParameterGroupsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListDbClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDbClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDbClustersResponse]
 */
public fun TimestreamInfluxDbClient.listDbClustersPaginated(initialRequest: ListDbClustersRequest = ListDbClustersRequest { }): Flow<ListDbClustersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDbClustersPaginated.listDbClusters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDbClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDbClustersResponse]
 */
public fun TimestreamInfluxDbClient.listDbClustersPaginated(block: ListDbClustersRequest.Builder.() -> Unit): Flow<ListDbClustersResponse> =
    listDbClustersPaginated(ListDbClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDbClustersPaginated]
 * to access the nested member [DbClusterSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbClusterSummary]
 */
@JvmName("listDbClustersResponseDbClusterSummary")
public fun Flow<ListDbClustersResponse>.items(): Flow<DbClusterSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDbInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDbInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDbInstancesResponse]
 */
public fun TimestreamInfluxDbClient.listDbInstancesPaginated(initialRequest: ListDbInstancesRequest = ListDbInstancesRequest { }): Flow<ListDbInstancesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDbInstancesPaginated.listDbInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDbInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDbInstancesResponse]
 */
public fun TimestreamInfluxDbClient.listDbInstancesPaginated(block: ListDbInstancesRequest.Builder.() -> Unit): Flow<ListDbInstancesResponse> =
    listDbInstancesPaginated(ListDbInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDbInstancesPaginated]
 * to access the nested member [DbInstanceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbInstanceSummary]
 */
@JvmName("listDbInstancesResponseDbInstanceSummary")
public fun Flow<ListDbInstancesResponse>.items(): Flow<DbInstanceSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDbInstancesForClusterResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDbInstancesForClusterRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDbInstancesForClusterResponse]
 */
public fun TimestreamInfluxDbClient.listDbInstancesForClusterPaginated(initialRequest: ListDbInstancesForClusterRequest): Flow<ListDbInstancesForClusterResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDbInstancesForClusterPaginated.listDbInstancesForCluster(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDbInstancesForClusterResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDbInstancesForClusterResponse]
 */
public fun TimestreamInfluxDbClient.listDbInstancesForClusterPaginated(block: ListDbInstancesForClusterRequest.Builder.() -> Unit): Flow<ListDbInstancesForClusterResponse> =
    listDbInstancesForClusterPaginated(ListDbInstancesForClusterRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDbInstancesForClusterPaginated]
 * to access the nested member [DbInstanceForClusterSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbInstanceForClusterSummary]
 */
@JvmName("listDbInstancesForClusterResponseDbInstanceForClusterSummary")
public fun Flow<ListDbInstancesForClusterResponse>.items(): Flow<DbInstanceForClusterSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDbParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDbParameterGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDbParameterGroupsResponse]
 */
public fun TimestreamInfluxDbClient.listDbParameterGroupsPaginated(initialRequest: ListDbParameterGroupsRequest = ListDbParameterGroupsRequest { }): Flow<ListDbParameterGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDbParameterGroupsPaginated.listDbParameterGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDbParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDbParameterGroupsResponse]
 */
public fun TimestreamInfluxDbClient.listDbParameterGroupsPaginated(block: ListDbParameterGroupsRequest.Builder.() -> Unit): Flow<ListDbParameterGroupsResponse> =
    listDbParameterGroupsPaginated(ListDbParameterGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDbParameterGroupsPaginated]
 * to access the nested member [DbParameterGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DbParameterGroupSummary]
 */
@JvmName("listDbParameterGroupsResponseDbParameterGroupSummary")
public fun Flow<ListDbParameterGroupsResponse>.items(): Flow<DbParameterGroupSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
