// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreaminfluxdb.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateDbInstanceResponse private constructor(builder: Builder) {
    /**
     * The amount of storage allocated for your DB storage type (in gibibytes).
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The Amazon Resource Name (ARN) of the DB instance.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The Availability Zone in which the DB instance resides.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Specifies the DbCluster to which this DbInstance belongs to.
     */
    public val dbClusterId: kotlin.String? = builder.dbClusterId
    /**
     * The Timestream for InfluxDB instance type that InfluxDB runs on.
     */
    public val dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = builder.dbInstanceType
    /**
     * The id of the DB parameter group assigned to your DB instance.
     */
    public val dbParameterGroupIdentifier: kotlin.String? = builder.dbParameterGroupIdentifier
    /**
     * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     */
    public val dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = builder.dbStorageType
    /**
     * Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High availability.
     */
    public val deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DeploymentType? = builder.deploymentType
    /**
     * The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * A service-generated unique identifier.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The Amazon Resource Name (ARN) of the Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password.
     */
    public val influxAuthParametersSecretArn: kotlin.String? = builder.influxAuthParametersSecretArn
    /**
     * Specifies the DbInstance's role in the cluster.
     */
    public val instanceMode: aws.sdk.kotlin.services.timestreaminfluxdb.model.InstanceMode? = builder.instanceMode
    /**
     * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
     */
    public val logDeliveryConfiguration: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration? = builder.logDeliveryConfiguration
    /**
     * This customer-supplied name uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Specifies whether the networkType of the Timestream for InfluxDB instance is IPV4, which can communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     */
    public val networkType: aws.sdk.kotlin.services.timestreaminfluxdb.model.NetworkType? = builder.networkType
    /**
     * The port number on which InfluxDB accepts connections.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * Indicates if the DB instance has a public IP to facilitate access.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The Availability Zone in which the standby instance is located when deploying with a MultiAZ standby instance.
     */
    public val secondaryAvailabilityZone: kotlin.String? = builder.secondaryAvailabilityZone
    /**
     * The status of the DB instance.
     */
    public val status: aws.sdk.kotlin.services.timestreaminfluxdb.model.Status? = builder.status
    /**
     * A list of VPC security group IDs associated with the DB instance.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds
    /**
     * A list of VPC subnet IDs associated with the DB instance.
     */
    public val vpcSubnetIds: List<String> = requireNotNull(builder.vpcSubnetIds) { "A non-null value must be provided for vpcSubnetIds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreaminfluxdb.model.UpdateDbInstanceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDbInstanceResponse(")
        append("allocatedStorage=$allocatedStorage,")
        append("arn=$arn,")
        append("availabilityZone=$availabilityZone,")
        append("dbClusterId=$dbClusterId,")
        append("dbInstanceType=$dbInstanceType,")
        append("dbParameterGroupIdentifier=$dbParameterGroupIdentifier,")
        append("dbStorageType=$dbStorageType,")
        append("deploymentType=$deploymentType,")
        append("endpoint=$endpoint,")
        append("id=$id,")
        append("influxAuthParametersSecretArn=$influxAuthParametersSecretArn,")
        append("instanceMode=$instanceMode,")
        append("logDeliveryConfiguration=$logDeliveryConfiguration,")
        append("name=$name,")
        append("networkType=$networkType,")
        append("port=$port,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("secondaryAvailabilityZone=$secondaryAvailabilityZone,")
        append("status=$status,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds,")
        append("vpcSubnetIds=$vpcSubnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (dbClusterId?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceType?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbStorageType?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (influxAuthParametersSecretArn?.hashCode() ?: 0)
        result = 31 * result + (instanceMode?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (secondaryAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (vpcSubnetIds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDbInstanceResponse

        if (allocatedStorage != other.allocatedStorage) return false
        if (arn != other.arn) return false
        if (availabilityZone != other.availabilityZone) return false
        if (dbClusterId != other.dbClusterId) return false
        if (dbInstanceType != other.dbInstanceType) return false
        if (dbParameterGroupIdentifier != other.dbParameterGroupIdentifier) return false
        if (dbStorageType != other.dbStorageType) return false
        if (deploymentType != other.deploymentType) return false
        if (endpoint != other.endpoint) return false
        if (id != other.id) return false
        if (influxAuthParametersSecretArn != other.influxAuthParametersSecretArn) return false
        if (instanceMode != other.instanceMode) return false
        if (logDeliveryConfiguration != other.logDeliveryConfiguration) return false
        if (name != other.name) return false
        if (networkType != other.networkType) return false
        if (port != other.port) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (secondaryAvailabilityZone != other.secondaryAvailabilityZone) return false
        if (status != other.status) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false
        if (vpcSubnetIds != other.vpcSubnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreaminfluxdb.model.UpdateDbInstanceResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of storage allocated for your DB storage type (in gibibytes).
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the DB instance.
         */
        public var arn: kotlin.String? = null
        /**
         * The Availability Zone in which the DB instance resides.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * Specifies the DbCluster to which this DbInstance belongs to.
         */
        public var dbClusterId: kotlin.String? = null
        /**
         * The Timestream for InfluxDB instance type that InfluxDB runs on.
         */
        public var dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = null
        /**
         * The id of the DB parameter group assigned to your DB instance.
         */
        public var dbParameterGroupIdentifier: kotlin.String? = null
        /**
         * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         */
        public var dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = null
        /**
         * Specifies whether the Timestream for InfluxDB is deployed as Single-AZ or with a MultiAZ Standby for High availability.
         */
        public var deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DeploymentType? = null
        /**
         * The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
         */
        public var endpoint: kotlin.String? = null
        /**
         * A service-generated unique identifier.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Secrets Manager secret containing the initial InfluxDB authorization parameters. The secret value is a JSON formatted key-value pair holding InfluxDB authorization values: organization, bucket, username, and password.
         */
        public var influxAuthParametersSecretArn: kotlin.String? = null
        /**
         * Specifies the DbInstance's role in the cluster.
         */
        public var instanceMode: aws.sdk.kotlin.services.timestreaminfluxdb.model.InstanceMode? = null
        /**
         * Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
         */
        public var logDeliveryConfiguration: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration? = null
        /**
         * This customer-supplied name uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and CLI commands.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies whether the networkType of the Timestream for InfluxDB instance is IPV4, which can communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         */
        public var networkType: aws.sdk.kotlin.services.timestreaminfluxdb.model.NetworkType? = null
        /**
         * The port number on which InfluxDB accepts connections.
         */
        public var port: kotlin.Int? = null
        /**
         * Indicates if the DB instance has a public IP to facilitate access.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The Availability Zone in which the standby instance is located when deploying with a MultiAZ standby instance.
         */
        public var secondaryAvailabilityZone: kotlin.String? = null
        /**
         * The status of the DB instance.
         */
        public var status: aws.sdk.kotlin.services.timestreaminfluxdb.model.Status? = null
        /**
         * A list of VPC security group IDs associated with the DB instance.
         */
        public var vpcSecurityGroupIds: List<String>? = null
        /**
         * A list of VPC subnet IDs associated with the DB instance.
         */
        public var vpcSubnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreaminfluxdb.model.UpdateDbInstanceResponse) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.arn = x.arn
            this.availabilityZone = x.availabilityZone
            this.dbClusterId = x.dbClusterId
            this.dbInstanceType = x.dbInstanceType
            this.dbParameterGroupIdentifier = x.dbParameterGroupIdentifier
            this.dbStorageType = x.dbStorageType
            this.deploymentType = x.deploymentType
            this.endpoint = x.endpoint
            this.id = x.id
            this.influxAuthParametersSecretArn = x.influxAuthParametersSecretArn
            this.instanceMode = x.instanceMode
            this.logDeliveryConfiguration = x.logDeliveryConfiguration
            this.name = x.name
            this.networkType = x.networkType
            this.port = x.port
            this.publiclyAccessible = x.publiclyAccessible
            this.secondaryAvailabilityZone = x.secondaryAvailabilityZone
            this.status = x.status
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
            this.vpcSubnetIds = x.vpcSubnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreaminfluxdb.model.UpdateDbInstanceResponse = UpdateDbInstanceResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration] inside the given [block]
         */
        public fun logDeliveryConfiguration(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration.Builder.() -> kotlin.Unit) {
            this.logDeliveryConfiguration = aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (name == null) name = ""
            if (vpcSubnetIds == null) vpcSubnetIds = emptyList()
            return this
        }
    }
}
