// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreaminfluxdb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a summary of a Timestream for InfluxDB cluster.
 */
public class DbClusterSummary private constructor(builder: Builder) {
    /**
     * The amount of storage allocated for your DB storage type (in gibibytes).
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The Amazon Resource Name (ARN) of the DB cluster.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The Timestream for InfluxDB DB instance type that InfluxDB runs on.
     */
    public val dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = builder.dbInstanceType
    /**
     * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
     */
    public val dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = builder.dbStorageType
    /**
     * Deployment type of the DB cluster
     */
    public val deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.ClusterDeploymentType? = builder.deploymentType
    /**
     * The endpoint used to connect to the Timestream for InfluxDB cluster for write and read operations.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * Service-generated unique identifier of the DB cluster to retrieve.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Customer supplied name of the Timestream for InfluxDB cluster.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Specifies whether the network type of the Timestream for InfluxDB Cluster is IPv4, which can communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     */
    public val networkType: aws.sdk.kotlin.services.timestreaminfluxdb.model.NetworkType? = builder.networkType
    /**
     * The port number on which InfluxDB accepts connections.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The endpoint used to connect to the Timestream for InfluxDB cluster for read-only operations.
     */
    public val readerEndpoint: kotlin.String? = builder.readerEndpoint
    /**
     * The status of the DB cluster.
     */
    public val status: aws.sdk.kotlin.services.timestreaminfluxdb.model.ClusterStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreaminfluxdb.model.DbClusterSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterSummary(")
        append("allocatedStorage=$allocatedStorage,")
        append("arn=$arn,")
        append("dbInstanceType=$dbInstanceType,")
        append("dbStorageType=$dbStorageType,")
        append("deploymentType=$deploymentType,")
        append("endpoint=$endpoint,")
        append("id=$id,")
        append("name=$name,")
        append("networkType=$networkType,")
        append("port=$port,")
        append("readerEndpoint=$readerEndpoint,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (dbInstanceType?.hashCode() ?: 0)
        result = 31 * result + (dbStorageType?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (readerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbClusterSummary

        if (allocatedStorage != other.allocatedStorage) return false
        if (arn != other.arn) return false
        if (dbInstanceType != other.dbInstanceType) return false
        if (dbStorageType != other.dbStorageType) return false
        if (deploymentType != other.deploymentType) return false
        if (endpoint != other.endpoint) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (networkType != other.networkType) return false
        if (port != other.port) return false
        if (readerEndpoint != other.readerEndpoint) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreaminfluxdb.model.DbClusterSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of storage allocated for your DB storage type (in gibibytes).
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the DB cluster.
         */
        public var arn: kotlin.String? = null
        /**
         * The Timestream for InfluxDB DB instance type that InfluxDB runs on.
         */
        public var dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = null
        /**
         * The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
         */
        public var dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = null
        /**
         * Deployment type of the DB cluster
         */
        public var deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.ClusterDeploymentType? = null
        /**
         * The endpoint used to connect to the Timestream for InfluxDB cluster for write and read operations.
         */
        public var endpoint: kotlin.String? = null
        /**
         * Service-generated unique identifier of the DB cluster to retrieve.
         */
        public var id: kotlin.String? = null
        /**
         * Customer supplied name of the Timestream for InfluxDB cluster.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies whether the network type of the Timestream for InfluxDB Cluster is IPv4, which can communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         */
        public var networkType: aws.sdk.kotlin.services.timestreaminfluxdb.model.NetworkType? = null
        /**
         * The port number on which InfluxDB accepts connections.
         */
        public var port: kotlin.Int? = null
        /**
         * The endpoint used to connect to the Timestream for InfluxDB cluster for read-only operations.
         */
        public var readerEndpoint: kotlin.String? = null
        /**
         * The status of the DB cluster.
         */
        public var status: aws.sdk.kotlin.services.timestreaminfluxdb.model.ClusterStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbClusterSummary) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.arn = x.arn
            this.dbInstanceType = x.dbInstanceType
            this.dbStorageType = x.dbStorageType
            this.deploymentType = x.deploymentType
            this.endpoint = x.endpoint
            this.id = x.id
            this.name = x.name
            this.networkType = x.networkType
            this.port = x.port
            this.readerEndpoint = x.readerEndpoint
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreaminfluxdb.model.DbClusterSummary = DbClusterSummary(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
