// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreaminfluxdb.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDbClusterRequest private constructor(builder: Builder) {
    /**
     * The amount of storage to allocate for your DB storage type in GiB (gibibytes).
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the concept of a database and a retention period (the duration of time that each data point persists). A bucket belongs to an organization.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The Timestream for InfluxDB DB instance type to run InfluxDB on.
     */
    public val dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = builder.dbInstanceType
    /**
     * The ID of the DB parameter group to assign to your DB cluster. DB parameter groups specify how the database is configured. For example, DB parameter groups can specify the limit for query concurrency.
     */
    public val dbParameterGroupIdentifier: kotlin.String? = builder.dbParameterGroupIdentifier
    /**
     * The Timestream for InfluxDB DB storage type to read and write InfluxDB data.
     *
     * You can choose between three different types of provisioned Influx IOPS Included storage according to your workload requirements:
     * + Influx I/O Included 3000 IOPS
     * + Influx I/O Included 12000 IOPS
     * + Influx I/O Included 16000 IOPS
     */
    public val dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = builder.dbStorageType
    /**
     * Specifies the type of cluster to create.
     */
    public val deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.ClusterDeploymentType? = builder.deploymentType
    /**
     * Specifies the behavior of failure recovery when the primary node of the cluster fails.
     */
    public val failoverMode: aws.sdk.kotlin.services.timestreaminfluxdb.model.FailoverMode? = builder.failoverMode
    /**
     * Configuration for sending InfluxDB engine logs to a specified S3 bucket.
     */
    public val logDeliveryConfiguration: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration? = builder.logDeliveryConfiguration
    /**
     * The name that uniquely identifies the DB cluster when interacting with the Amazon Timestream for InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB cluster names must be unique per customer and per region.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
     */
    public val networkType: aws.sdk.kotlin.services.timestreaminfluxdb.model.NetworkType? = builder.networkType
    /**
     * The name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a workspace for a group of users.
     */
    public val organization: kotlin.String? = builder.organization
    /**
     * The password of the initial admin user created in InfluxDB. This password will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. These attributes will be stored in a secret created in Secrets Manager in your account.
     */
    public val password: kotlin.String? = builder.password
    /**
     * The port number on which InfluxDB accepts connections.
     *
     * Valid Values: 1024-65535
     *
     * Default: 8086
     *
     * Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
     */
    public val port: kotlin.Int? = builder.port
    /**
     * Configures the Timestream for InfluxDB cluster with a public IP to facilitate access from outside the VPC.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * A list of key-value pairs to associate with the DB instance.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a hyphen or contain two consecutive hyphens. For example, my-user1. This username will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. These attributes will be stored in a secret created in Secrets Manager in your account.
     */
    public val username: kotlin.String? = builder.username
    /**
     * A list of VPC security group IDs to associate with the Timestream for InfluxDB cluster.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds
    /**
     * A list of VPC subnet IDs to associate with the DB cluster. Provide at least two VPC subnet IDs in different Availability Zones when deploying with a Multi-AZ standby.
     */
    public val vpcSubnetIds: List<String>? = builder.vpcSubnetIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreaminfluxdb.model.CreateDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbClusterRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("bucket=$bucket,")
        append("dbInstanceType=$dbInstanceType,")
        append("dbParameterGroupIdentifier=$dbParameterGroupIdentifier,")
        append("dbStorageType=$dbStorageType,")
        append("deploymentType=$deploymentType,")
        append("failoverMode=$failoverMode,")
        append("logDeliveryConfiguration=$logDeliveryConfiguration,")
        append("name=$name,")
        append("networkType=$networkType,")
        append("organization=$organization,")
        append("password=*** Sensitive Data Redacted ***,")
        append("port=$port,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("tags=$tags,")
        append("username=*** Sensitive Data Redacted ***,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds,")
        append("vpcSubnetIds=$vpcSubnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceType?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbStorageType?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (failoverMode?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (organization?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (vpcSubnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbClusterRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (bucket != other.bucket) return false
        if (dbInstanceType != other.dbInstanceType) return false
        if (dbParameterGroupIdentifier != other.dbParameterGroupIdentifier) return false
        if (dbStorageType != other.dbStorageType) return false
        if (deploymentType != other.deploymentType) return false
        if (failoverMode != other.failoverMode) return false
        if (logDeliveryConfiguration != other.logDeliveryConfiguration) return false
        if (name != other.name) return false
        if (networkType != other.networkType) return false
        if (organization != other.organization) return false
        if (password != other.password) return false
        if (port != other.port) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (tags != other.tags) return false
        if (username != other.username) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false
        if (vpcSubnetIds != other.vpcSubnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreaminfluxdb.model.CreateDbClusterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of storage to allocate for your DB storage type in GiB (gibibytes).
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * The name of the initial InfluxDB bucket. All InfluxDB data is stored in a bucket. A bucket combines the concept of a database and a retention period (the duration of time that each data point persists). A bucket belongs to an organization.
         */
        public var bucket: kotlin.String? = null
        /**
         * The Timestream for InfluxDB DB instance type to run InfluxDB on.
         */
        public var dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = null
        /**
         * The ID of the DB parameter group to assign to your DB cluster. DB parameter groups specify how the database is configured. For example, DB parameter groups can specify the limit for query concurrency.
         */
        public var dbParameterGroupIdentifier: kotlin.String? = null
        /**
         * The Timestream for InfluxDB DB storage type to read and write InfluxDB data.
         *
         * You can choose between three different types of provisioned Influx IOPS Included storage according to your workload requirements:
         * + Influx I/O Included 3000 IOPS
         * + Influx I/O Included 12000 IOPS
         * + Influx I/O Included 16000 IOPS
         */
        public var dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = null
        /**
         * Specifies the type of cluster to create.
         */
        public var deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.ClusterDeploymentType? = null
        /**
         * Specifies the behavior of failure recovery when the primary node of the cluster fails.
         */
        public var failoverMode: aws.sdk.kotlin.services.timestreaminfluxdb.model.FailoverMode? = null
        /**
         * Configuration for sending InfluxDB engine logs to a specified S3 bucket.
         */
        public var logDeliveryConfiguration: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration? = null
        /**
         * The name that uniquely identifies the DB cluster when interacting with the Amazon Timestream for InfluxDB API and CLI commands. This name will also be a prefix included in the endpoint. DB cluster names must be unique per customer and per region.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies whether the network type of the Timestream for InfluxDB cluster is IPv4, which can communicate over IPv4 protocol only, or DUAL, which can communicate over both IPv4 and IPv6 protocols.
         */
        public var networkType: aws.sdk.kotlin.services.timestreaminfluxdb.model.NetworkType? = null
        /**
         * The name of the initial organization for the initial admin user in InfluxDB. An InfluxDB organization is a workspace for a group of users.
         */
        public var organization: kotlin.String? = null
        /**
         * The password of the initial admin user created in InfluxDB. This password will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. These attributes will be stored in a secret created in Secrets Manager in your account.
         */
        public var password: kotlin.String? = null
        /**
         * The port number on which InfluxDB accepts connections.
         *
         * Valid Values: 1024-65535
         *
         * Default: 8086
         *
         * Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
         */
        public var port: kotlin.Int? = null
        /**
         * Configures the Timestream for InfluxDB cluster with a public IP to facilitate access from outside the VPC.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * A list of key-value pairs to associate with the DB instance.
         */
        public var tags: Map<String, String>? = null
        /**
         * The username of the initial admin user created in InfluxDB. Must start with a letter and can't end with a hyphen or contain two consecutive hyphens. For example, my-user1. This username will allow you to access the InfluxDB UI to perform various administrative tasks and also use the InfluxDB CLI to create an operator token. These attributes will be stored in a secret created in Secrets Manager in your account.
         */
        public var username: kotlin.String? = null
        /**
         * A list of VPC security group IDs to associate with the Timestream for InfluxDB cluster.
         */
        public var vpcSecurityGroupIds: List<String>? = null
        /**
         * A list of VPC subnet IDs to associate with the DB cluster. Provide at least two VPC subnet IDs in different Availability Zones when deploying with a Multi-AZ standby.
         */
        public var vpcSubnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreaminfluxdb.model.CreateDbClusterRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.bucket = x.bucket
            this.dbInstanceType = x.dbInstanceType
            this.dbParameterGroupIdentifier = x.dbParameterGroupIdentifier
            this.dbStorageType = x.dbStorageType
            this.deploymentType = x.deploymentType
            this.failoverMode = x.failoverMode
            this.logDeliveryConfiguration = x.logDeliveryConfiguration
            this.name = x.name
            this.networkType = x.networkType
            this.organization = x.organization
            this.password = x.password
            this.port = x.port
            this.publiclyAccessible = x.publiclyAccessible
            this.tags = x.tags
            this.username = x.username
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
            this.vpcSubnetIds = x.vpcSubnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreaminfluxdb.model.CreateDbClusterRequest = CreateDbClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration] inside the given [block]
         */
        public fun logDeliveryConfiguration(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration.Builder.() -> kotlin.Unit) {
            this.logDeliveryConfiguration = aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
