// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreaminfluxdb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
 */
public class InfluxDbV2Parameters private constructor(builder: Builder) {
    /**
     * Include option to show detailed logs for Flux queries.
     *
     * Default: false
     */
    public val fluxLogEnabled: kotlin.Boolean? = builder.fluxLogEnabled
    /**
     * Maximum duration the server should keep established connections alive while waiting for new requests. Set to 0 for no timeout.
     *
     * Default: 3 minutes
     */
    public val httpIdleTimeout: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = builder.httpIdleTimeout
    /**
     * Maximum duration the server should try to read HTTP headers for new requests. Set to 0 for no timeout.
     *
     * Default: 10 seconds
     */
    public val httpReadHeaderTimeout: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = builder.httpReadHeaderTimeout
    /**
     * Maximum duration the server should try to read the entirety of new requests. Set to 0 for no timeout.
     *
     * Default: 0
     */
    public val httpReadTimeout: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = builder.httpReadTimeout
    /**
     * Maximum duration the server should spend processing and responding to write requests. Set to 0 for no timeout.
     *
     * Default: 0
     */
    public val httpWriteTimeout: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = builder.httpWriteTimeout
    /**
     * Maximum number of group by time buckets a SELECT statement can create. 0 allows an unlimited number of buckets.
     *
     * Default: 0
     */
    public val influxqlMaxSelectBuckets: kotlin.Long? = builder.influxqlMaxSelectBuckets
    /**
     * Maximum number of points a SELECT statement can process. 0 allows an unlimited number of points. InfluxDB checks the point count every second (so queries exceeding the maximum aren’t immediately aborted).
     *
     * Default: 0
     */
    public val influxqlMaxSelectPoint: kotlin.Long? = builder.influxqlMaxSelectPoint
    /**
     * Maximum number of series a SELECT statement can return. 0 allows an unlimited number of series.
     *
     * Default: 0
     */
    public val influxqlMaxSelectSeries: kotlin.Long? = builder.influxqlMaxSelectSeries
    /**
     * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level specified.
     *
     * Default: info
     */
    public val logLevel: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogLevel? = builder.logLevel
    /**
     * Disable the HTTP /metrics endpoint which exposes [internal InfluxDB metrics](https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/).
     *
     * Default: false
     */
    public val metricsDisabled: kotlin.Boolean? = builder.metricsDisabled
    /**
     * Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to start InfluxDB without scheduling or executing tasks.
     *
     * Default: false
     */
    public val noTasks: kotlin.Boolean? = builder.noTasks
    /**
     * Disable the /debug/pprof HTTP endpoint. This endpoint provides runtime profiling data and can be helpful when debugging.
     *
     * Default: true
     */
    public val pprofDisabled: kotlin.Boolean? = builder.pprofDisabled
    /**
     * Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of concurrent queries.
     *
     * Default: 0
     */
    public val queryConcurrency: kotlin.Int? = builder.queryConcurrency
    /**
     * Initial bytes of memory allocated for a query.
     *
     * Default: 0
     */
    public val queryInitialMemoryBytes: kotlin.Long? = builder.queryInitialMemoryBytes
    /**
     * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected. Setting to 0 allows an unlimited number of queries in the queue.
     *
     * Default: 0
     */
    public val queryMaxMemoryBytes: kotlin.Long? = builder.queryMaxMemoryBytes
    /**
     * Maximum bytes of memory allowed for a single query. Must be greater or equal to queryInitialMemoryBytes.
     *
     * Default: 0
     */
    public val queryMemoryBytes: kotlin.Long? = builder.queryMemoryBytes
    /**
     * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected. Setting to 0 allows an unlimited number of queries in the queue.
     *
     * Default: 0
     */
    public val queryQueueSize: kotlin.Int? = builder.queryQueueSize
    /**
     * Specifies the Time to Live (TTL) in minutes for newly created user sessions.
     *
     * Default: 60
     */
    public val sessionLength: kotlin.Int? = builder.sessionLength
    /**
     * Disables automatically extending a user’s session TTL on each request. By default, every request sets the session’s expiration time to five minutes from now. When disabled, sessions expire after the specified [session length](https://docs.influxdata.com/influxdb/v2/reference/config-options/#session-length) and the user is redirected to the login page, even if recently active.
     *
     * Default: false
     */
    public val sessionRenewDisabled: kotlin.Boolean? = builder.sessionRenewDisabled
    /**
     * Maximum size (in bytes) a shard’s cache can reach before it starts rejecting writes. Must be greater than storageCacheSnapShotMemorySize and lower than instance’s total memory capacity. We recommend setting it to below 15% of the total memory capacity.
     *
     * Default: 1073741824
     */
    public val storageCacheMaxMemorySize: kotlin.Long? = builder.storageCacheMaxMemorySize
    /**
     * Size (in bytes) at which the storage engine will snapshot the cache and write it to a TSM file to make more memory available. Must not be greater than storageCacheMaxMemorySize.
     *
     * Default: 26214400
     */
    public val storageCacheSnapshotMemorySize: kotlin.Long? = builder.storageCacheSnapshotMemorySize
    /**
     * Duration at which the storage engine will snapshot the cache and write it to a new TSM file if the shard hasn’t received writes or deletes.
     *
     * Default: 10 minutes
     */
    public val storageCacheSnapshotWriteColdDuration: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = builder.storageCacheSnapshotWriteColdDuration
    /**
     * Duration at which the storage engine will compact all TSM files in a shard if it hasn't received writes or deletes.
     *
     * Default: 4 hours
     */
    public val storageCompactFullWriteColdDuration: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = builder.storageCompactFullWriteColdDuration
    /**
     * Rate limit (in bytes per second) that TSM compactions can write to disk.
     *
     * Default: 50331648
     */
    public val storageCompactThroughputBurst: kotlin.Long? = builder.storageCompactThroughputBurst
    /**
     * Maximum number of full and level compactions that can run concurrently. A value of 0 results in 50% of runtime.GOMAXPROCS(0) used at runtime. Any number greater than zero limits compactions to that value. This setting does not apply to cache snapshotting.
     *
     * Default: 0
     */
    public val storageMaxConcurrentCompactions: kotlin.Int? = builder.storageMaxConcurrentCompactions
    /**
     * Size (in bytes) at which an index write-ahead log (WAL) file will compact into an index file. Lower sizes will cause log files to be compacted more quickly and result in lower heap usage at the expense of write throughput.
     *
     * Default: 1048576
     */
    public val storageMaxIndexLogFileSize: kotlin.Long? = builder.storageMaxIndexLogFileSize
    /**
     * Skip field size validation on incoming write requests.
     *
     * Default: false
     */
    public val storageNoValidateFieldSize: kotlin.Boolean? = builder.storageNoValidateFieldSize
    /**
     * Interval of retention policy enforcement checks. Must be greater than 0.
     *
     * Default: 30 minutes
     */
    public val storageRetentionCheckInterval: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = builder.storageRetentionCheckInterval
    /**
     * Maximum number of snapshot compactions that can run concurrently across all series partitions in a database.
     *
     * Default: 0
     */
    public val storageSeriesFileMaxConcurrentSnapshotCompactions: kotlin.Int? = builder.storageSeriesFileMaxConcurrentSnapshotCompactions
    /**
     * Size of the internal cache used in the TSI index to store previously calculated series results. Cached results are returned quickly rather than needing to be recalculated when a subsequent query with the same tag key/value predicate is executed. Setting this value to 0 will disable the cache and may decrease query performance.
     *
     * Default: 100
     */
    public val storageSeriesIdSetCacheSize: kotlin.Long? = builder.storageSeriesIdSetCacheSize
    /**
     * Maximum number writes to the WAL directory to attempt at the same time. Setting this value to 0 results in number of processing units available x2.
     *
     * Default: 0
     */
    public val storageWalMaxConcurrentWrites: kotlin.Int? = builder.storageWalMaxConcurrentWrites
    /**
     * Maximum amount of time a write request to the WAL directory will wait when the [maximum number of concurrent active writes to the WAL directory has been met](https://docs.influxdata.com/influxdb/v2/reference/config-options/#storage-wal-max-concurrent-writes). Set to 0 to disable the timeout.
     *
     * Default: 10 minutes
     */
    public val storageWalMaxWriteDelay: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = builder.storageWalMaxWriteDelay
    /**
     * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
     */
    public val tracingType: aws.sdk.kotlin.services.timestreaminfluxdb.model.TracingType? = builder.tracingType
    /**
     * Disable the InfluxDB user interface (UI). The UI is enabled by default.
     *
     * Default: false
     */
    public val uiDisabled: kotlin.Boolean? = builder.uiDisabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreaminfluxdb.model.InfluxDbV2Parameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InfluxDbV2Parameters(")
        append("fluxLogEnabled=$fluxLogEnabled,")
        append("httpIdleTimeout=$httpIdleTimeout,")
        append("httpReadHeaderTimeout=$httpReadHeaderTimeout,")
        append("httpReadTimeout=$httpReadTimeout,")
        append("httpWriteTimeout=$httpWriteTimeout,")
        append("influxqlMaxSelectBuckets=$influxqlMaxSelectBuckets,")
        append("influxqlMaxSelectPoint=$influxqlMaxSelectPoint,")
        append("influxqlMaxSelectSeries=$influxqlMaxSelectSeries,")
        append("logLevel=$logLevel,")
        append("metricsDisabled=$metricsDisabled,")
        append("noTasks=$noTasks,")
        append("pprofDisabled=$pprofDisabled,")
        append("queryConcurrency=$queryConcurrency,")
        append("queryInitialMemoryBytes=$queryInitialMemoryBytes,")
        append("queryMaxMemoryBytes=$queryMaxMemoryBytes,")
        append("queryMemoryBytes=$queryMemoryBytes,")
        append("queryQueueSize=$queryQueueSize,")
        append("sessionLength=$sessionLength,")
        append("sessionRenewDisabled=$sessionRenewDisabled,")
        append("storageCacheMaxMemorySize=$storageCacheMaxMemorySize,")
        append("storageCacheSnapshotMemorySize=$storageCacheSnapshotMemorySize,")
        append("storageCacheSnapshotWriteColdDuration=$storageCacheSnapshotWriteColdDuration,")
        append("storageCompactFullWriteColdDuration=$storageCompactFullWriteColdDuration,")
        append("storageCompactThroughputBurst=$storageCompactThroughputBurst,")
        append("storageMaxConcurrentCompactions=$storageMaxConcurrentCompactions,")
        append("storageMaxIndexLogFileSize=$storageMaxIndexLogFileSize,")
        append("storageNoValidateFieldSize=$storageNoValidateFieldSize,")
        append("storageRetentionCheckInterval=$storageRetentionCheckInterval,")
        append("storageSeriesFileMaxConcurrentSnapshotCompactions=$storageSeriesFileMaxConcurrentSnapshotCompactions,")
        append("storageSeriesIdSetCacheSize=$storageSeriesIdSetCacheSize,")
        append("storageWalMaxConcurrentWrites=$storageWalMaxConcurrentWrites,")
        append("storageWalMaxWriteDelay=$storageWalMaxWriteDelay,")
        append("tracingType=$tracingType,")
        append("uiDisabled=$uiDisabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fluxLogEnabled?.hashCode() ?: 0
        result = 31 * result + (httpIdleTimeout?.hashCode() ?: 0)
        result = 31 * result + (httpReadHeaderTimeout?.hashCode() ?: 0)
        result = 31 * result + (httpReadTimeout?.hashCode() ?: 0)
        result = 31 * result + (httpWriteTimeout?.hashCode() ?: 0)
        result = 31 * result + (influxqlMaxSelectBuckets?.hashCode() ?: 0)
        result = 31 * result + (influxqlMaxSelectPoint?.hashCode() ?: 0)
        result = 31 * result + (influxqlMaxSelectSeries?.hashCode() ?: 0)
        result = 31 * result + (logLevel?.hashCode() ?: 0)
        result = 31 * result + (metricsDisabled?.hashCode() ?: 0)
        result = 31 * result + (noTasks?.hashCode() ?: 0)
        result = 31 * result + (pprofDisabled?.hashCode() ?: 0)
        result = 31 * result + (queryConcurrency ?: 0)
        result = 31 * result + (queryInitialMemoryBytes?.hashCode() ?: 0)
        result = 31 * result + (queryMaxMemoryBytes?.hashCode() ?: 0)
        result = 31 * result + (queryMemoryBytes?.hashCode() ?: 0)
        result = 31 * result + (queryQueueSize ?: 0)
        result = 31 * result + (sessionLength ?: 0)
        result = 31 * result + (sessionRenewDisabled?.hashCode() ?: 0)
        result = 31 * result + (storageCacheMaxMemorySize?.hashCode() ?: 0)
        result = 31 * result + (storageCacheSnapshotMemorySize?.hashCode() ?: 0)
        result = 31 * result + (storageCacheSnapshotWriteColdDuration?.hashCode() ?: 0)
        result = 31 * result + (storageCompactFullWriteColdDuration?.hashCode() ?: 0)
        result = 31 * result + (storageCompactThroughputBurst?.hashCode() ?: 0)
        result = 31 * result + (storageMaxConcurrentCompactions ?: 0)
        result = 31 * result + (storageMaxIndexLogFileSize?.hashCode() ?: 0)
        result = 31 * result + (storageNoValidateFieldSize?.hashCode() ?: 0)
        result = 31 * result + (storageRetentionCheckInterval?.hashCode() ?: 0)
        result = 31 * result + (storageSeriesFileMaxConcurrentSnapshotCompactions ?: 0)
        result = 31 * result + (storageSeriesIdSetCacheSize?.hashCode() ?: 0)
        result = 31 * result + (storageWalMaxConcurrentWrites ?: 0)
        result = 31 * result + (storageWalMaxWriteDelay?.hashCode() ?: 0)
        result = 31 * result + (tracingType?.hashCode() ?: 0)
        result = 31 * result + (uiDisabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InfluxDbV2Parameters

        if (fluxLogEnabled != other.fluxLogEnabled) return false
        if (httpIdleTimeout != other.httpIdleTimeout) return false
        if (httpReadHeaderTimeout != other.httpReadHeaderTimeout) return false
        if (httpReadTimeout != other.httpReadTimeout) return false
        if (httpWriteTimeout != other.httpWriteTimeout) return false
        if (influxqlMaxSelectBuckets != other.influxqlMaxSelectBuckets) return false
        if (influxqlMaxSelectPoint != other.influxqlMaxSelectPoint) return false
        if (influxqlMaxSelectSeries != other.influxqlMaxSelectSeries) return false
        if (logLevel != other.logLevel) return false
        if (metricsDisabled != other.metricsDisabled) return false
        if (noTasks != other.noTasks) return false
        if (pprofDisabled != other.pprofDisabled) return false
        if (queryConcurrency != other.queryConcurrency) return false
        if (queryInitialMemoryBytes != other.queryInitialMemoryBytes) return false
        if (queryMaxMemoryBytes != other.queryMaxMemoryBytes) return false
        if (queryMemoryBytes != other.queryMemoryBytes) return false
        if (queryQueueSize != other.queryQueueSize) return false
        if (sessionLength != other.sessionLength) return false
        if (sessionRenewDisabled != other.sessionRenewDisabled) return false
        if (storageCacheMaxMemorySize != other.storageCacheMaxMemorySize) return false
        if (storageCacheSnapshotMemorySize != other.storageCacheSnapshotMemorySize) return false
        if (storageCacheSnapshotWriteColdDuration != other.storageCacheSnapshotWriteColdDuration) return false
        if (storageCompactFullWriteColdDuration != other.storageCompactFullWriteColdDuration) return false
        if (storageCompactThroughputBurst != other.storageCompactThroughputBurst) return false
        if (storageMaxConcurrentCompactions != other.storageMaxConcurrentCompactions) return false
        if (storageMaxIndexLogFileSize != other.storageMaxIndexLogFileSize) return false
        if (storageNoValidateFieldSize != other.storageNoValidateFieldSize) return false
        if (storageRetentionCheckInterval != other.storageRetentionCheckInterval) return false
        if (storageSeriesFileMaxConcurrentSnapshotCompactions != other.storageSeriesFileMaxConcurrentSnapshotCompactions) return false
        if (storageSeriesIdSetCacheSize != other.storageSeriesIdSetCacheSize) return false
        if (storageWalMaxConcurrentWrites != other.storageWalMaxConcurrentWrites) return false
        if (storageWalMaxWriteDelay != other.storageWalMaxWriteDelay) return false
        if (tracingType != other.tracingType) return false
        if (uiDisabled != other.uiDisabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreaminfluxdb.model.InfluxDbV2Parameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Include option to show detailed logs for Flux queries.
         *
         * Default: false
         */
        public var fluxLogEnabled: kotlin.Boolean? = null
        /**
         * Maximum duration the server should keep established connections alive while waiting for new requests. Set to 0 for no timeout.
         *
         * Default: 3 minutes
         */
        public var httpIdleTimeout: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = null
        /**
         * Maximum duration the server should try to read HTTP headers for new requests. Set to 0 for no timeout.
         *
         * Default: 10 seconds
         */
        public var httpReadHeaderTimeout: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = null
        /**
         * Maximum duration the server should try to read the entirety of new requests. Set to 0 for no timeout.
         *
         * Default: 0
         */
        public var httpReadTimeout: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = null
        /**
         * Maximum duration the server should spend processing and responding to write requests. Set to 0 for no timeout.
         *
         * Default: 0
         */
        public var httpWriteTimeout: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = null
        /**
         * Maximum number of group by time buckets a SELECT statement can create. 0 allows an unlimited number of buckets.
         *
         * Default: 0
         */
        public var influxqlMaxSelectBuckets: kotlin.Long? = null
        /**
         * Maximum number of points a SELECT statement can process. 0 allows an unlimited number of points. InfluxDB checks the point count every second (so queries exceeding the maximum aren’t immediately aborted).
         *
         * Default: 0
         */
        public var influxqlMaxSelectPoint: kotlin.Long? = null
        /**
         * Maximum number of series a SELECT statement can return. 0 allows an unlimited number of series.
         *
         * Default: 0
         */
        public var influxqlMaxSelectSeries: kotlin.Long? = null
        /**
         * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level specified.
         *
         * Default: info
         */
        public var logLevel: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogLevel? = null
        /**
         * Disable the HTTP /metrics endpoint which exposes [internal InfluxDB metrics](https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/).
         *
         * Default: false
         */
        public var metricsDisabled: kotlin.Boolean? = null
        /**
         * Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to start InfluxDB without scheduling or executing tasks.
         *
         * Default: false
         */
        public var noTasks: kotlin.Boolean? = null
        /**
         * Disable the /debug/pprof HTTP endpoint. This endpoint provides runtime profiling data and can be helpful when debugging.
         *
         * Default: true
         */
        public var pprofDisabled: kotlin.Boolean? = null
        /**
         * Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of concurrent queries.
         *
         * Default: 0
         */
        public var queryConcurrency: kotlin.Int? = null
        /**
         * Initial bytes of memory allocated for a query.
         *
         * Default: 0
         */
        public var queryInitialMemoryBytes: kotlin.Long? = null
        /**
         * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected. Setting to 0 allows an unlimited number of queries in the queue.
         *
         * Default: 0
         */
        public var queryMaxMemoryBytes: kotlin.Long? = null
        /**
         * Maximum bytes of memory allowed for a single query. Must be greater or equal to queryInitialMemoryBytes.
         *
         * Default: 0
         */
        public var queryMemoryBytes: kotlin.Long? = null
        /**
         * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected. Setting to 0 allows an unlimited number of queries in the queue.
         *
         * Default: 0
         */
        public var queryQueueSize: kotlin.Int? = null
        /**
         * Specifies the Time to Live (TTL) in minutes for newly created user sessions.
         *
         * Default: 60
         */
        public var sessionLength: kotlin.Int? = null
        /**
         * Disables automatically extending a user’s session TTL on each request. By default, every request sets the session’s expiration time to five minutes from now. When disabled, sessions expire after the specified [session length](https://docs.influxdata.com/influxdb/v2/reference/config-options/#session-length) and the user is redirected to the login page, even if recently active.
         *
         * Default: false
         */
        public var sessionRenewDisabled: kotlin.Boolean? = null
        /**
         * Maximum size (in bytes) a shard’s cache can reach before it starts rejecting writes. Must be greater than storageCacheSnapShotMemorySize and lower than instance’s total memory capacity. We recommend setting it to below 15% of the total memory capacity.
         *
         * Default: 1073741824
         */
        public var storageCacheMaxMemorySize: kotlin.Long? = null
        /**
         * Size (in bytes) at which the storage engine will snapshot the cache and write it to a TSM file to make more memory available. Must not be greater than storageCacheMaxMemorySize.
         *
         * Default: 26214400
         */
        public var storageCacheSnapshotMemorySize: kotlin.Long? = null
        /**
         * Duration at which the storage engine will snapshot the cache and write it to a new TSM file if the shard hasn’t received writes or deletes.
         *
         * Default: 10 minutes
         */
        public var storageCacheSnapshotWriteColdDuration: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = null
        /**
         * Duration at which the storage engine will compact all TSM files in a shard if it hasn't received writes or deletes.
         *
         * Default: 4 hours
         */
        public var storageCompactFullWriteColdDuration: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = null
        /**
         * Rate limit (in bytes per second) that TSM compactions can write to disk.
         *
         * Default: 50331648
         */
        public var storageCompactThroughputBurst: kotlin.Long? = null
        /**
         * Maximum number of full and level compactions that can run concurrently. A value of 0 results in 50% of runtime.GOMAXPROCS(0) used at runtime. Any number greater than zero limits compactions to that value. This setting does not apply to cache snapshotting.
         *
         * Default: 0
         */
        public var storageMaxConcurrentCompactions: kotlin.Int? = null
        /**
         * Size (in bytes) at which an index write-ahead log (WAL) file will compact into an index file. Lower sizes will cause log files to be compacted more quickly and result in lower heap usage at the expense of write throughput.
         *
         * Default: 1048576
         */
        public var storageMaxIndexLogFileSize: kotlin.Long? = null
        /**
         * Skip field size validation on incoming write requests.
         *
         * Default: false
         */
        public var storageNoValidateFieldSize: kotlin.Boolean? = null
        /**
         * Interval of retention policy enforcement checks. Must be greater than 0.
         *
         * Default: 30 minutes
         */
        public var storageRetentionCheckInterval: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = null
        /**
         * Maximum number of snapshot compactions that can run concurrently across all series partitions in a database.
         *
         * Default: 0
         */
        public var storageSeriesFileMaxConcurrentSnapshotCompactions: kotlin.Int? = null
        /**
         * Size of the internal cache used in the TSI index to store previously calculated series results. Cached results are returned quickly rather than needing to be recalculated when a subsequent query with the same tag key/value predicate is executed. Setting this value to 0 will disable the cache and may decrease query performance.
         *
         * Default: 100
         */
        public var storageSeriesIdSetCacheSize: kotlin.Long? = null
        /**
         * Maximum number writes to the WAL directory to attempt at the same time. Setting this value to 0 results in number of processing units available x2.
         *
         * Default: 0
         */
        public var storageWalMaxConcurrentWrites: kotlin.Int? = null
        /**
         * Maximum amount of time a write request to the WAL directory will wait when the [maximum number of concurrent active writes to the WAL directory has been met](https://docs.influxdata.com/influxdb/v2/reference/config-options/#storage-wal-max-concurrent-writes). Set to 0 to disable the timeout.
         *
         * Default: 10 minutes
         */
        public var storageWalMaxWriteDelay: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration? = null
        /**
         * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
         */
        public var tracingType: aws.sdk.kotlin.services.timestreaminfluxdb.model.TracingType? = null
        /**
         * Disable the InfluxDB user interface (UI). The UI is enabled by default.
         *
         * Default: false
         */
        public var uiDisabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreaminfluxdb.model.InfluxDbV2Parameters) : this() {
            this.fluxLogEnabled = x.fluxLogEnabled
            this.httpIdleTimeout = x.httpIdleTimeout
            this.httpReadHeaderTimeout = x.httpReadHeaderTimeout
            this.httpReadTimeout = x.httpReadTimeout
            this.httpWriteTimeout = x.httpWriteTimeout
            this.influxqlMaxSelectBuckets = x.influxqlMaxSelectBuckets
            this.influxqlMaxSelectPoint = x.influxqlMaxSelectPoint
            this.influxqlMaxSelectSeries = x.influxqlMaxSelectSeries
            this.logLevel = x.logLevel
            this.metricsDisabled = x.metricsDisabled
            this.noTasks = x.noTasks
            this.pprofDisabled = x.pprofDisabled
            this.queryConcurrency = x.queryConcurrency
            this.queryInitialMemoryBytes = x.queryInitialMemoryBytes
            this.queryMaxMemoryBytes = x.queryMaxMemoryBytes
            this.queryMemoryBytes = x.queryMemoryBytes
            this.queryQueueSize = x.queryQueueSize
            this.sessionLength = x.sessionLength
            this.sessionRenewDisabled = x.sessionRenewDisabled
            this.storageCacheMaxMemorySize = x.storageCacheMaxMemorySize
            this.storageCacheSnapshotMemorySize = x.storageCacheSnapshotMemorySize
            this.storageCacheSnapshotWriteColdDuration = x.storageCacheSnapshotWriteColdDuration
            this.storageCompactFullWriteColdDuration = x.storageCompactFullWriteColdDuration
            this.storageCompactThroughputBurst = x.storageCompactThroughputBurst
            this.storageMaxConcurrentCompactions = x.storageMaxConcurrentCompactions
            this.storageMaxIndexLogFileSize = x.storageMaxIndexLogFileSize
            this.storageNoValidateFieldSize = x.storageNoValidateFieldSize
            this.storageRetentionCheckInterval = x.storageRetentionCheckInterval
            this.storageSeriesFileMaxConcurrentSnapshotCompactions = x.storageSeriesFileMaxConcurrentSnapshotCompactions
            this.storageSeriesIdSetCacheSize = x.storageSeriesIdSetCacheSize
            this.storageWalMaxConcurrentWrites = x.storageWalMaxConcurrentWrites
            this.storageWalMaxWriteDelay = x.storageWalMaxWriteDelay
            this.tracingType = x.tracingType
            this.uiDisabled = x.uiDisabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreaminfluxdb.model.InfluxDbV2Parameters = InfluxDbV2Parameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration] inside the given [block]
         */
        public fun httpIdleTimeout(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.Builder.() -> kotlin.Unit) {
            this.httpIdleTimeout = aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration] inside the given [block]
         */
        public fun httpReadHeaderTimeout(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.Builder.() -> kotlin.Unit) {
            this.httpReadHeaderTimeout = aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration] inside the given [block]
         */
        public fun httpReadTimeout(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.Builder.() -> kotlin.Unit) {
            this.httpReadTimeout = aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration] inside the given [block]
         */
        public fun httpWriteTimeout(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.Builder.() -> kotlin.Unit) {
            this.httpWriteTimeout = aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration] inside the given [block]
         */
        public fun storageCacheSnapshotWriteColdDuration(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.Builder.() -> kotlin.Unit) {
            this.storageCacheSnapshotWriteColdDuration = aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration] inside the given [block]
         */
        public fun storageCompactFullWriteColdDuration(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.Builder.() -> kotlin.Unit) {
            this.storageCompactFullWriteColdDuration = aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration] inside the given [block]
         */
        public fun storageRetentionCheckInterval(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.Builder.() -> kotlin.Unit) {
            this.storageRetentionCheckInterval = aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration] inside the given [block]
         */
        public fun storageWalMaxWriteDelay(block: aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.Builder.() -> kotlin.Unit) {
            this.storageWalMaxWriteDelay = aws.sdk.kotlin.services.timestreaminfluxdb.model.Duration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
