// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreaminfluxdb.serde

import aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType
import aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType
import aws.sdk.kotlin.services.timestreaminfluxdb.model.DeploymentType
import aws.sdk.kotlin.services.timestreaminfluxdb.model.LogDeliveryConfiguration
import aws.sdk.kotlin.services.timestreaminfluxdb.model.Status
import aws.sdk.kotlin.services.timestreaminfluxdb.model.TimestreamInfluxDbException
import aws.sdk.kotlin.services.timestreaminfluxdb.model.UpdateDbInstanceResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateDbInstanceOperationDeserializer: HttpDeserializer.NonStreaming<UpdateDbInstanceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateDbInstanceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateDbInstanceError(context, call, payload)
        }
        val builder = UpdateDbInstanceResponse.Builder()

        if (payload != null) {
            deserializeUpdateDbInstanceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateDbInstanceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TimestreamInfluxDbException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TimestreamInfluxDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDbInstanceOperationBody(builder: UpdateDbInstanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALLOCATEDSTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("allocatedStorage"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val AVAILABILITYZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("availabilityZone"))
    val DBINSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("dbInstanceType"))
    val DBPARAMETERGROUPIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dbParameterGroupIdentifier"))
    val DBSTORAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("dbStorageType"))
    val DEPLOYMENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("deploymentType"))
    val ENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("endpoint"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val INFLUXAUTHPARAMETERSSECRETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("influxAuthParametersSecretArn"))
    val LOGDELIVERYCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logDeliveryConfiguration"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PUBLICLYACCESSIBLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("publiclyAccessible"))
    val SECONDARYAVAILABILITYZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("secondaryAvailabilityZone"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val VPCSECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("vpcSecurityGroupIds"))
    val VPCSUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("vpcSubnetIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOCATEDSTORAGE_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(AVAILABILITYZONE_DESCRIPTOR)
        field(DBINSTANCETYPE_DESCRIPTOR)
        field(DBPARAMETERGROUPIDENTIFIER_DESCRIPTOR)
        field(DBSTORAGETYPE_DESCRIPTOR)
        field(DEPLOYMENTTYPE_DESCRIPTOR)
        field(ENDPOINT_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(INFLUXAUTHPARAMETERSSECRETARN_DESCRIPTOR)
        field(LOGDELIVERYCONFIGURATION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PUBLICLYACCESSIBLE_DESCRIPTOR)
        field(SECONDARYAVAILABILITYZONE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(VPCSECURITYGROUPIDS_DESCRIPTOR)
        field(VPCSUBNETIDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOCATEDSTORAGE_DESCRIPTOR.index -> builder.allocatedStorage = deserializeInt()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                AVAILABILITYZONE_DESCRIPTOR.index -> builder.availabilityZone = deserializeString()
                DBINSTANCETYPE_DESCRIPTOR.index -> builder.dbInstanceType = deserializeString().let { DbInstanceType.fromValue(it) }
                DBPARAMETERGROUPIDENTIFIER_DESCRIPTOR.index -> builder.dbParameterGroupIdentifier = deserializeString()
                DBSTORAGETYPE_DESCRIPTOR.index -> builder.dbStorageType = deserializeString().let { DbStorageType.fromValue(it) }
                DEPLOYMENTTYPE_DESCRIPTOR.index -> builder.deploymentType = deserializeString().let { DeploymentType.fromValue(it) }
                ENDPOINT_DESCRIPTOR.index -> builder.endpoint = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                INFLUXAUTHPARAMETERSSECRETARN_DESCRIPTOR.index -> builder.influxAuthParametersSecretArn = deserializeString()
                LOGDELIVERYCONFIGURATION_DESCRIPTOR.index -> builder.logDeliveryConfiguration = deserializeLogDeliveryConfigurationDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PUBLICLYACCESSIBLE_DESCRIPTOR.index -> builder.publiclyAccessible = deserializeBoolean()
                SECONDARYAVAILABILITYZONE_DESCRIPTOR.index -> builder.secondaryAvailabilityZone = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { Status.fromValue(it) }
                VPCSECURITYGROUPIDS_DESCRIPTOR.index -> builder.vpcSecurityGroupIds =
                    deserializer.deserializeList(VPCSECURITYGROUPIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VPCSUBNETIDS_DESCRIPTOR.index -> builder.vpcSubnetIds =
                    deserializer.deserializeList(VPCSUBNETIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
