// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreaminfluxdb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
 */
public class InfluxDbV2Parameters private constructor(builder: Builder) {
    /**
     * Include option to show detailed logs for Flux queries.
     *
     * Default: false
     */
    public val fluxLogEnabled: kotlin.Boolean? = builder.fluxLogEnabled
    /**
     * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level specified.
     *
     * Default: info
     */
    public val logLevel: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogLevel? = builder.logLevel
    /**
     * Disable the HTTP /metrics endpoint which exposes [internal InfluxDB metrics](https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/).
     *
     * Default: false
     */
    public val metricsDisabled: kotlin.Boolean? = builder.metricsDisabled
    /**
     * Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to start InfluxDB without scheduling or executing tasks.
     *
     * Default: false
     */
    public val noTasks: kotlin.Boolean? = builder.noTasks
    /**
     * Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of concurrent queries.
     *
     * Default: 0
     */
    public val queryConcurrency: kotlin.Int? = builder.queryConcurrency
    /**
     * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected. Setting to 0 allows an unlimited number of queries in the queue.
     *
     * Default: 0
     */
    public val queryQueueSize: kotlin.Int? = builder.queryQueueSize
    /**
     * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
     */
    public val tracingType: aws.sdk.kotlin.services.timestreaminfluxdb.model.TracingType? = builder.tracingType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreaminfluxdb.model.InfluxDbV2Parameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InfluxDbV2Parameters(")
        append("fluxLogEnabled=$fluxLogEnabled,")
        append("logLevel=$logLevel,")
        append("metricsDisabled=$metricsDisabled,")
        append("noTasks=$noTasks,")
        append("queryConcurrency=$queryConcurrency,")
        append("queryQueueSize=$queryQueueSize,")
        append("tracingType=$tracingType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fluxLogEnabled?.hashCode() ?: 0
        result = 31 * result + (logLevel?.hashCode() ?: 0)
        result = 31 * result + (metricsDisabled?.hashCode() ?: 0)
        result = 31 * result + (noTasks?.hashCode() ?: 0)
        result = 31 * result + (queryConcurrency ?: 0)
        result = 31 * result + (queryQueueSize ?: 0)
        result = 31 * result + (tracingType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InfluxDbV2Parameters

        if (fluxLogEnabled != other.fluxLogEnabled) return false
        if (logLevel != other.logLevel) return false
        if (metricsDisabled != other.metricsDisabled) return false
        if (noTasks != other.noTasks) return false
        if (queryConcurrency != other.queryConcurrency) return false
        if (queryQueueSize != other.queryQueueSize) return false
        if (tracingType != other.tracingType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreaminfluxdb.model.InfluxDbV2Parameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Include option to show detailed logs for Flux queries.
         *
         * Default: false
         */
        public var fluxLogEnabled: kotlin.Boolean? = null
        /**
         * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level specified.
         *
         * Default: info
         */
        public var logLevel: aws.sdk.kotlin.services.timestreaminfluxdb.model.LogLevel? = null
        /**
         * Disable the HTTP /metrics endpoint which exposes [internal InfluxDB metrics](https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/).
         *
         * Default: false
         */
        public var metricsDisabled: kotlin.Boolean? = null
        /**
         * Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to start InfluxDB without scheduling or executing tasks.
         *
         * Default: false
         */
        public var noTasks: kotlin.Boolean? = null
        /**
         * Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of concurrent queries.
         *
         * Default: 0
         */
        public var queryConcurrency: kotlin.Int? = null
        /**
         * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected. Setting to 0 allows an unlimited number of queries in the queue.
         *
         * Default: 0
         */
        public var queryQueueSize: kotlin.Int? = null
        /**
         * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
         */
        public var tracingType: aws.sdk.kotlin.services.timestreaminfluxdb.model.TracingType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreaminfluxdb.model.InfluxDbV2Parameters) : this() {
            this.fluxLogEnabled = x.fluxLogEnabled
            this.logLevel = x.logLevel
            this.metricsDisabled = x.metricsDisabled
            this.noTasks = x.noTasks
            this.queryConcurrency = x.queryConcurrency
            this.queryQueueSize = x.queryQueueSize
            this.tracingType = x.tracingType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreaminfluxdb.model.InfluxDbV2Parameters = InfluxDbV2Parameters(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
