// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreaminfluxdb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains a summary of a DB instance.
 */
public class DbInstanceSummary private constructor(builder: Builder) {
    /**
     * The amount of storage to allocate for your DbStorageType in GiB (gibibytes).
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The Amazon Resource Name (ARN) of the DB instance.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The Timestream for InfluxDB instance type to run InfluxDB on.
     */
    public val dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = builder.dbInstanceType
    /**
     * The storage type for your DB instance.
     */
    public val dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = builder.dbStorageType
    /**
     * Single-Instance or with a MultiAZ Standby for High availability.
     */
    public val deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DeploymentType? = builder.deploymentType
    /**
     * The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The service-generated unique identifier of the DB instance.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * This customer-supplied name uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and AWS CLI commands.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the DB instance.
     */
    public val status: aws.sdk.kotlin.services.timestreaminfluxdb.model.Status? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbInstanceSummary(")
        append("allocatedStorage=$allocatedStorage,")
        append("arn=$arn,")
        append("dbInstanceType=$dbInstanceType,")
        append("dbStorageType=$dbStorageType,")
        append("deploymentType=$deploymentType,")
        append("endpoint=$endpoint,")
        append("id=$id,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (dbInstanceType?.hashCode() ?: 0)
        result = 31 * result + (dbStorageType?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbInstanceSummary

        if (allocatedStorage != other.allocatedStorage) return false
        if (arn != other.arn) return false
        if (dbInstanceType != other.dbInstanceType) return false
        if (dbStorageType != other.dbStorageType) return false
        if (deploymentType != other.deploymentType) return false
        if (endpoint != other.endpoint) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of storage to allocate for your DbStorageType in GiB (gibibytes).
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the DB instance.
         */
        public var arn: kotlin.String? = null
        /**
         * The Timestream for InfluxDB instance type to run InfluxDB on.
         */
        public var dbInstanceType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceType? = null
        /**
         * The storage type for your DB instance.
         */
        public var dbStorageType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbStorageType? = null
        /**
         * Single-Instance or with a MultiAZ Standby for High availability.
         */
        public var deploymentType: aws.sdk.kotlin.services.timestreaminfluxdb.model.DeploymentType? = null
        /**
         * The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The service-generated unique identifier of the DB instance.
         */
        public var id: kotlin.String? = null
        /**
         * This customer-supplied name uniquely identifies the DB instance when interacting with the Amazon Timestream for InfluxDB API and AWS CLI commands.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the DB instance.
         */
        public var status: aws.sdk.kotlin.services.timestreaminfluxdb.model.Status? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceSummary) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.arn = x.arn
            this.dbInstanceType = x.dbInstanceType
            this.dbStorageType = x.dbStorageType
            this.deploymentType = x.deploymentType
            this.endpoint = x.endpoint
            this.id = x.id
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreaminfluxdb.model.DbInstanceSummary = DbInstanceSummary(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
