// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.transform

import aws.sdk.kotlin.services.textract.model.AnalyzeDocumentRequest
import aws.sdk.kotlin.services.textract.model.Document
import aws.sdk.kotlin.services.textract.model.FeatureType
import aws.sdk.kotlin.services.textract.model.HumanLoopConfig
import aws.sdk.kotlin.services.textract.model.QueriesConfig
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AnalyzeDocumentOperationSerializer: HttpSerialize<AnalyzeDocumentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: AnalyzeDocumentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeAnalyzeDocumentOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeAnalyzeDocumentOperationBody(context: ExecutionContext, input: AnalyzeDocumentRequest): ByteArray {
    val serializer = JsonSerializer()
    val DOCUMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Document"))
    val FEATURETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FeatureTypes"))
    val HUMANLOOPCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HumanLoopConfig"))
    val QUERIESCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QueriesConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOCUMENT_DESCRIPTOR)
        field(FEATURETYPES_DESCRIPTOR)
        field(HUMANLOOPCONFIG_DESCRIPTOR)
        field(QUERIESCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.document?.let { field(DOCUMENT_DESCRIPTOR, it, ::serializeDocumentDocument) }
        if (input.featureTypes != null) {
            listField(FEATURETYPES_DESCRIPTOR) {
                for (el0 in input.featureTypes) {
                    serializeString(el0.value)
                }
            }
        }
        input.humanLoopConfig?.let { field(HUMANLOOPCONFIG_DESCRIPTOR, it, ::serializeHumanLoopConfigDocument) }
        input.queriesConfig?.let { field(QUERIESCONFIG_DESCRIPTOR, it, ::serializeQueriesConfigDocument) }
    }
    return serializer.toByteArray()
}
