// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



public class StartDocumentTextDetectionRequest private constructor(builder: Builder) {
    /**
     * The idempotent token that's used to identify the start request. If you use the same token with multiple `StartDocumentTextDetection` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidentally started more than once. For more information, see [Calling Amazon Textract Asynchronous Operations](https://docs.aws.amazon.com/textract/latest/dg/api-async.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The location of the document to be processed.
     */
    public val documentLocation: aws.sdk.kotlin.services.textract.model.DocumentLocation? = builder.documentLocation
    /**
     * An identifier that you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use `JobTag` to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).
     */
    public val jobTag: kotlin.String? = builder.jobTag
    /**
     * The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to.
     */
    public val notificationChannel: aws.sdk.kotlin.services.textract.model.NotificationChannel? = builder.notificationChannel
    /**
     * Sets if the output will go to a customer defined bucket. By default Amazon Textract will save the results internally to be accessed with the GetDocumentTextDetection operation.
     */
    public val outputConfig: aws.sdk.kotlin.services.textract.model.OutputConfig? = builder.outputConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.StartDocumentTextDetectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartDocumentTextDetectionRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("documentLocation=$documentLocation,")
        append("jobTag=$jobTag,")
        append("kmsKeyId=$kmsKeyId,")
        append("notificationChannel=$notificationChannel,")
        append("outputConfig=$outputConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (documentLocation?.hashCode() ?: 0)
        result = 31 * result + (jobTag?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (notificationChannel?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartDocumentTextDetectionRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (documentLocation != other.documentLocation) return false
        if (jobTag != other.jobTag) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (notificationChannel != other.notificationChannel) return false
        if (outputConfig != other.outputConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.StartDocumentTextDetectionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The idempotent token that's used to identify the start request. If you use the same token with multiple `StartDocumentTextDetection` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidentally started more than once. For more information, see [Calling Amazon Textract Asynchronous Operations](https://docs.aws.amazon.com/textract/latest/dg/api-async.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The location of the document to be processed.
         */
        public var documentLocation: aws.sdk.kotlin.services.textract.model.DocumentLocation? = null
        /**
         * An identifier that you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use `JobTag` to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).
         */
        public var jobTag: kotlin.String? = null
        /**
         * The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to.
         */
        public var notificationChannel: aws.sdk.kotlin.services.textract.model.NotificationChannel? = null
        /**
         * Sets if the output will go to a customer defined bucket. By default Amazon Textract will save the results internally to be accessed with the GetDocumentTextDetection operation.
         */
        public var outputConfig: aws.sdk.kotlin.services.textract.model.OutputConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.StartDocumentTextDetectionRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.documentLocation = x.documentLocation
            this.jobTag = x.jobTag
            this.kmsKeyId = x.kmsKeyId
            this.notificationChannel = x.notificationChannel
            this.outputConfig = x.outputConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.StartDocumentTextDetectionRequest = StartDocumentTextDetectionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.DocumentLocation] inside the given [block]
         */
        public fun documentLocation(block: aws.sdk.kotlin.services.textract.model.DocumentLocation.Builder.() -> kotlin.Unit) {
            this.documentLocation = aws.sdk.kotlin.services.textract.model.DocumentLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.NotificationChannel] inside the given [block]
         */
        public fun notificationChannel(block: aws.sdk.kotlin.services.textract.model.NotificationChannel.Builder.() -> kotlin.Unit) {
            this.notificationChannel = aws.sdk.kotlin.services.textract.model.NotificationChannel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.OutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.textract.model.OutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.textract.model.OutputConfig.invoke(block)
        }
    }
}
