// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



/**
 * Sets up the human review workflow the document will be sent to if one of the conditions is met. You can also set certain attributes of the image before review.
 */
public class HumanLoopConfig private constructor(builder: Builder) {
    /**
     * Sets attributes of the input data.
     */
    public val dataAttributes: aws.sdk.kotlin.services.textract.model.HumanLoopDataAttributes? = builder.dataAttributes
    /**
     * The Amazon Resource Name (ARN) of the flow definition.
     */
    public val flowDefinitionArn: kotlin.String? = builder.flowDefinitionArn
    /**
     * The name of the human workflow used for this image. This should be kept unique within a region.
     */
    public val humanLoopName: kotlin.String? = builder.humanLoopName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.HumanLoopConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HumanLoopConfig(")
        append("dataAttributes=$dataAttributes,")
        append("flowDefinitionArn=$flowDefinitionArn,")
        append("humanLoopName=$humanLoopName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataAttributes?.hashCode() ?: 0
        result = 31 * result + (flowDefinitionArn?.hashCode() ?: 0)
        result = 31 * result + (humanLoopName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HumanLoopConfig

        if (dataAttributes != other.dataAttributes) return false
        if (flowDefinitionArn != other.flowDefinitionArn) return false
        if (humanLoopName != other.humanLoopName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.HumanLoopConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Sets attributes of the input data.
         */
        public var dataAttributes: aws.sdk.kotlin.services.textract.model.HumanLoopDataAttributes? = null
        /**
         * The Amazon Resource Name (ARN) of the flow definition.
         */
        public var flowDefinitionArn: kotlin.String? = null
        /**
         * The name of the human workflow used for this image. This should be kept unique within a region.
         */
        public var humanLoopName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.HumanLoopConfig) : this() {
            this.dataAttributes = x.dataAttributes
            this.flowDefinitionArn = x.flowDefinitionArn
            this.humanLoopName = x.humanLoopName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.HumanLoopConfig = HumanLoopConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.HumanLoopDataAttributes] inside the given [block]
         */
        public fun dataAttributes(block: aws.sdk.kotlin.services.textract.model.HumanLoopDataAttributes.Builder.() -> kotlin.Unit) {
            this.dataAttributes = aws.sdk.kotlin.services.textract.model.HumanLoopDataAttributes.invoke(block)
        }
    }
}
