// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



public class AnalyzeDocumentRequest private constructor(builder: Builder) {
    /**
     * The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Textract operations, you can't pass image bytes. The document must be an image in JPEG, PNG, PDF, or TIFF format.
     *
     * If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are passed using the `Bytes` field.
     */
    public val document: aws.sdk.kotlin.services.textract.model.Document? = builder.document
    /**
     * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis, add TABLES and FORMS to `FeatureTypes`. All lines and words detected in the document are included in the response (including text that isn't related to the value of `FeatureTypes`).
     */
    public val featureTypes: List<FeatureType>? = builder.featureTypes
    /**
     * Sets the configuration for the human in the loop workflow for analyzing documents.
     */
    public val humanLoopConfig: aws.sdk.kotlin.services.textract.model.HumanLoopConfig? = builder.humanLoopConfig
    /**
     * Contains Queries and the alias for those Queries, as determined by the input.
     */
    public val queriesConfig: aws.sdk.kotlin.services.textract.model.QueriesConfig? = builder.queriesConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.AnalyzeDocumentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalyzeDocumentRequest(")
        append("document=$document,")
        append("featureTypes=$featureTypes,")
        append("humanLoopConfig=$humanLoopConfig,")
        append("queriesConfig=$queriesConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = document?.hashCode() ?: 0
        result = 31 * result + (featureTypes?.hashCode() ?: 0)
        result = 31 * result + (humanLoopConfig?.hashCode() ?: 0)
        result = 31 * result + (queriesConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalyzeDocumentRequest

        if (document != other.document) return false
        if (featureTypes != other.featureTypes) return false
        if (humanLoopConfig != other.humanLoopConfig) return false
        if (queriesConfig != other.queriesConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.AnalyzeDocumentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The input document as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Textract operations, you can't pass image bytes. The document must be an image in JPEG, PNG, PDF, or TIFF format.
         *
         * If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes that are passed using the `Bytes` field.
         */
        public var document: aws.sdk.kotlin.services.textract.model.Document? = null
        /**
         * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis, add TABLES and FORMS to `FeatureTypes`. All lines and words detected in the document are included in the response (including text that isn't related to the value of `FeatureTypes`).
         */
        public var featureTypes: List<FeatureType>? = null
        /**
         * Sets the configuration for the human in the loop workflow for analyzing documents.
         */
        public var humanLoopConfig: aws.sdk.kotlin.services.textract.model.HumanLoopConfig? = null
        /**
         * Contains Queries and the alias for those Queries, as determined by the input.
         */
        public var queriesConfig: aws.sdk.kotlin.services.textract.model.QueriesConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.AnalyzeDocumentRequest) : this() {
            this.document = x.document
            this.featureTypes = x.featureTypes
            this.humanLoopConfig = x.humanLoopConfig
            this.queriesConfig = x.queriesConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.AnalyzeDocumentRequest = AnalyzeDocumentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.Document] inside the given [block]
         */
        public fun document(block: aws.sdk.kotlin.services.textract.model.Document.Builder.() -> kotlin.Unit) {
            this.document = aws.sdk.kotlin.services.textract.model.Document.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.HumanLoopConfig] inside the given [block]
         */
        public fun humanLoopConfig(block: aws.sdk.kotlin.services.textract.model.HumanLoopConfig.Builder.() -> kotlin.Unit) {
            this.humanLoopConfig = aws.sdk.kotlin.services.textract.model.HumanLoopConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.QueriesConfig] inside the given [block]
         */
        public fun queriesConfig(block: aws.sdk.kotlin.services.textract.model.QueriesConfig.Builder.() -> kotlin.Unit) {
            this.queriesConfig = aws.sdk.kotlin.services.textract.model.QueriesConfig.invoke(block)
        }
    }
}
