// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.serde

import aws.sdk.kotlin.services.textract.model.Block
import aws.sdk.kotlin.services.textract.model.DetectDocumentTextResponse
import aws.sdk.kotlin.services.textract.model.DocumentMetadata
import aws.sdk.kotlin.services.textract.model.TextractException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DetectDocumentTextOperationDeserializer: HttpDeserializer.NonStreaming<DetectDocumentTextResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DetectDocumentTextResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDetectDocumentTextError(context, call, payload)
        }
        val builder = DetectDocumentTextResponse.Builder()

        if (payload != null) {
            deserializeDetectDocumentTextOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDetectDocumentTextError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TextractException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadDocumentException" -> BadDocumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DocumentTooLargeException" -> DocumentTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidS3ObjectException" -> InvalidS3ObjectExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedDocumentException" -> UnsupportedDocumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        else -> TextractException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDetectDocumentTextOperationBody(builder: DetectDocumentTextResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLOCKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Blocks"))
    val DETECTDOCUMENTTEXTMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DetectDocumentTextModelVersion"))
    val DOCUMENTMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DocumentMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOCKS_DESCRIPTOR)
        field(DETECTDOCUMENTTEXTMODELVERSION_DESCRIPTOR)
        field(DOCUMENTMETADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOCKS_DESCRIPTOR.index -> builder.blocks =
                    deserializer.deserializeList(BLOCKS_DESCRIPTOR) {
                        val col0 = mutableListOf<Block>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBlockDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DETECTDOCUMENTTEXTMODELVERSION_DESCRIPTOR.index -> builder.detectDocumentTextModelVersion = deserializeString()
                DOCUMENTMETADATA_DESCRIPTOR.index -> builder.documentMetadata = deserializeDocumentMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
