// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Sets whether or not your output will go to a user created bucket. Used to set the name of the bucket, and the prefix on the output file.
 *
 * `OutputConfig` is an optional parameter which lets you adjust where your output will be placed. By default, Amazon Textract will store the results internally and can only be accessed by the Get API operations. With `OutputConfig` enabled, you can set the name of the bucket the output will be sent to the file prefix of the results where you can download your results. Additionally, you can set the `KMSKeyID` parameter to a customer master key (CMK) to encrypt your output. Without this parameter set Amazon Textract will encrypt server-side using the AWS managed CMK for Amazon S3.
 *
 * Decryption of Customer Content is necessary for processing of the documents by Amazon Textract. If your account is opted out under an AI services opt out policy then all unencrypted Customer Content is immediately and permanently deleted after the Customer Content has been processed by the service. No copy of of the output is retained by Amazon Textract. For information about how to opt out, see [ Managing AI services opt-out policy. ](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
 *
 * For more information on data privacy, see the [Data Privacy FAQ](https://aws.amazon.com/compliance/data-privacy-faq/).
 */
public class OutputConfig private constructor(builder: Builder) {
    /**
     * The name of the bucket your output will go to.
     */
    public val s3Bucket: kotlin.String = requireNotNull(builder.s3Bucket) { "A non-null value must be provided for s3Bucket" }
    /**
     * The prefix of the object key that the output will be saved to. When not enabled, the prefix will be “textract_output".
     */
    public val s3Prefix: kotlin.String? = builder.s3Prefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.OutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OutputConfig(")
        append("s3Bucket=$s3Bucket,")
        append("s3Prefix=$s3Prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3Bucket.hashCode()
        result = 31 * result + (s3Prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OutputConfig

        if (s3Bucket != other.s3Bucket) return false
        if (s3Prefix != other.s3Prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.OutputConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the bucket your output will go to.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The prefix of the object key that the output will be saved to. When not enabled, the prefix will be “textract_output".
         */
        public var s3Prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.OutputConfig) : this() {
            this.s3Bucket = x.s3Bucket
            this.s3Prefix = x.s3Prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.OutputConfig = OutputConfig(this)

        internal fun correctErrors(): Builder {
            if (s3Bucket == null) s3Bucket = ""
            return this
        }
    }
}
