// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Amazon Simple Notification Service (Amazon SNS) topic to which Amazon Textract publishes the completion status of an asynchronous document operation.
 */
public class NotificationChannel private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an IAM role that gives Amazon Textract publishing permissions to the Amazon SNS topic.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The Amazon SNS topic that Amazon Textract posts the completion status to.
     */
    public val snsTopicArn: kotlin.String = requireNotNull(builder.snsTopicArn) { "A non-null value must be provided for snsTopicArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.NotificationChannel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotificationChannel(")
        append("roleArn=$roleArn,")
        append("snsTopicArn=$snsTopicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn.hashCode()
        result = 31 * result + (snsTopicArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotificationChannel

        if (roleArn != other.roleArn) return false
        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.NotificationChannel = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of an IAM role that gives Amazon Textract publishing permissions to the Amazon SNS topic.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The Amazon SNS topic that Amazon Textract posts the completion status to.
         */
        public var snsTopicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.NotificationChannel) : this() {
            this.roleArn = x.roleArn
            this.snsTopicArn = x.snsTopicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.NotificationChannel = NotificationChannel(this)

        internal fun correctErrors(): Builder {
            if (roleArn == null) roleArn = ""
            if (snsTopicArn == null) snsTopicArn = ""
            return this
        }
    }
}
