// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The structure holding all the information returned by AnalyzeExpense
 */
public class ExpenseDocument private constructor(builder: Builder) {
    /**
     * This is a block object, the same as reported when DetectDocumentText is run on a document. It provides word level recognition of text.
     */
    public val blocks: List<Block>? = builder.blocks
    /**
     * Denotes which invoice or receipt in the document the information is coming from. First document will be 1, the second 2, and so on.
     */
    public val expenseIndex: kotlin.Int? = builder.expenseIndex
    /**
     * Information detected on each table of a document, seperated into `LineItems`.
     */
    public val lineItemGroups: List<LineItemGroup>? = builder.lineItemGroups
    /**
     * Any information found outside of a table by Amazon Textract.
     */
    public val summaryFields: List<ExpenseField>? = builder.summaryFields

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.ExpenseDocument = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExpenseDocument(")
        append("blocks=$blocks,")
        append("expenseIndex=$expenseIndex,")
        append("lineItemGroups=$lineItemGroups,")
        append("summaryFields=$summaryFields")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blocks?.hashCode() ?: 0
        result = 31 * result + (expenseIndex ?: 0)
        result = 31 * result + (lineItemGroups?.hashCode() ?: 0)
        result = 31 * result + (summaryFields?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExpenseDocument

        if (blocks != other.blocks) return false
        if (expenseIndex != other.expenseIndex) return false
        if (lineItemGroups != other.lineItemGroups) return false
        if (summaryFields != other.summaryFields) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.ExpenseDocument = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This is a block object, the same as reported when DetectDocumentText is run on a document. It provides word level recognition of text.
         */
        public var blocks: List<Block>? = null
        /**
         * Denotes which invoice or receipt in the document the information is coming from. First document will be 1, the second 2, and so on.
         */
        public var expenseIndex: kotlin.Int? = null
        /**
         * Information detected on each table of a document, seperated into `LineItems`.
         */
        public var lineItemGroups: List<LineItemGroup>? = null
        /**
         * Any information found outside of a table by Amazon Textract.
         */
        public var summaryFields: List<ExpenseField>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.ExpenseDocument) : this() {
            this.blocks = x.blocks
            this.expenseIndex = x.expenseIndex
            this.lineItemGroups = x.lineItemGroups
            this.summaryFields = x.summaryFields
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.ExpenseDocument = ExpenseDocument(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
