// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Summary information about documents grouped by the same document type.
 */
public class DocumentGroup private constructor(builder: Builder) {
    /**
     * A list of the detected signatures found in a document group.
     */
    public val detectedSignatures: List<DetectedSignature>? = builder.detectedSignatures
    /**
     * An array that contains information about the pages of a document, defined by logical boundary.
     */
    public val splitDocuments: List<SplitDocument>? = builder.splitDocuments
    /**
     * The type of document that Amazon Textract has detected. See [Analyze Lending Response Objects](https://docs.aws.amazon.com/textract/latest/dg/lending-response-objects.html) for a list of all types returned by Textract.
     */
    public val type: kotlin.String? = builder.type
    /**
     * A list of any expected signatures not found in a document group.
     */
    public val undetectedSignatures: List<UndetectedSignature>? = builder.undetectedSignatures

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.DocumentGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentGroup(")
        append("detectedSignatures=$detectedSignatures,")
        append("splitDocuments=$splitDocuments,")
        append("type=$type,")
        append("undetectedSignatures=$undetectedSignatures")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = detectedSignatures?.hashCode() ?: 0
        result = 31 * result + (splitDocuments?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (undetectedSignatures?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentGroup

        if (detectedSignatures != other.detectedSignatures) return false
        if (splitDocuments != other.splitDocuments) return false
        if (type != other.type) return false
        if (undetectedSignatures != other.undetectedSignatures) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.DocumentGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of the detected signatures found in a document group.
         */
        public var detectedSignatures: List<DetectedSignature>? = null
        /**
         * An array that contains information about the pages of a document, defined by logical boundary.
         */
        public var splitDocuments: List<SplitDocument>? = null
        /**
         * The type of document that Amazon Textract has detected. See [Analyze Lending Response Objects](https://docs.aws.amazon.com/textract/latest/dg/lending-response-objects.html) for a list of all types returned by Textract.
         */
        public var type: kotlin.String? = null
        /**
         * A list of any expected signatures not found in a document group.
         */
        public var undetectedSignatures: List<UndetectedSignature>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.DocumentGroup) : this() {
            this.detectedSignatures = x.detectedSignatures
            this.splitDocuments = x.splitDocuments
            this.type = x.type
            this.undetectedSignatures = x.undetectedSignatures
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.DocumentGroup = DocumentGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
