// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAdapterRequest private constructor(builder: Builder) {
    /**
     * The name to be assigned to the adapter being created.
     */
    public val adapterName: kotlin.String? = builder.adapterName
    /**
     * Controls whether or not the adapter should automatically update.
     */
    public val autoUpdate: aws.sdk.kotlin.services.textract.model.AutoUpdate? = builder.autoUpdate
    /**
     * Idempotent token is used to recognize the request. If the same token is used with multiple CreateAdapter requests, the same session is returned. This token is employed to avoid unintentionally creating the same session multiple times.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The description to be assigned to the adapter being created.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The type of feature that the adapter is being trained on. Currrenly, supported feature types are: `QUERIES`
     */
    public val featureTypes: List<FeatureType>? = builder.featureTypes
    /**
     * A list of tags to be added to the adapter.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.CreateAdapterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAdapterRequest(")
        append("adapterName=$adapterName,")
        append("autoUpdate=$autoUpdate,")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("featureTypes=$featureTypes,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adapterName?.hashCode() ?: 0
        result = 31 * result + (autoUpdate?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (featureTypes?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAdapterRequest

        if (adapterName != other.adapterName) return false
        if (autoUpdate != other.autoUpdate) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (featureTypes != other.featureTypes) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.CreateAdapterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name to be assigned to the adapter being created.
         */
        public var adapterName: kotlin.String? = null
        /**
         * Controls whether or not the adapter should automatically update.
         */
        public var autoUpdate: aws.sdk.kotlin.services.textract.model.AutoUpdate? = null
        /**
         * Idempotent token is used to recognize the request. If the same token is used with multiple CreateAdapter requests, the same session is returned. This token is employed to avoid unintentionally creating the same session multiple times.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The description to be assigned to the adapter being created.
         */
        public var description: kotlin.String? = null
        /**
         * The type of feature that the adapter is being trained on. Currrenly, supported feature types are: `QUERIES`
         */
        public var featureTypes: List<FeatureType>? = null
        /**
         * A list of tags to be added to the adapter.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.CreateAdapterRequest) : this() {
            this.adapterName = x.adapterName
            this.autoUpdate = x.autoUpdate
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.featureTypes = x.featureTypes
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.CreateAdapterRequest = CreateAdapterRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
