// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.serde

import aws.sdk.kotlin.services.textract.model.AdaptersConfig
import aws.sdk.kotlin.services.textract.model.DocumentLocation
import aws.sdk.kotlin.services.textract.model.FeatureType
import aws.sdk.kotlin.services.textract.model.NotificationChannel
import aws.sdk.kotlin.services.textract.model.OutputConfig
import aws.sdk.kotlin.services.textract.model.QueriesConfig
import aws.sdk.kotlin.services.textract.model.StartDocumentAnalysisRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartDocumentAnalysisOperationSerializer: HttpSerializer.NonStreaming<StartDocumentAnalysisRequest> {
    override fun serialize(context: ExecutionContext, input: StartDocumentAnalysisRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeStartDocumentAnalysisOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeStartDocumentAnalysisOperationBody(context: ExecutionContext, input: StartDocumentAnalysisRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADAPTERSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AdaptersConfig"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val DOCUMENTLOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DocumentLocation"))
    val FEATURETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FeatureTypes"))
    val JOBTAG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobTag"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KMSKeyId"))
    val NOTIFICATIONCHANNEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NotificationChannel"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val QUERIESCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QueriesConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADAPTERSCONFIG_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(DOCUMENTLOCATION_DESCRIPTOR)
        field(FEATURETYPES_DESCRIPTOR)
        field(JOBTAG_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(NOTIFICATIONCHANNEL_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(QUERIESCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.adaptersConfig?.let { field(ADAPTERSCONFIG_DESCRIPTOR, it, ::serializeAdaptersConfigDocument) }
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) }
        input.documentLocation?.let { field(DOCUMENTLOCATION_DESCRIPTOR, it, ::serializeDocumentLocationDocument) }
        if (input.featureTypes != null) {
            listField(FEATURETYPES_DESCRIPTOR) {
                for (el0 in input.featureTypes) {
                    serializeString(el0.value)
                }
            }
        }
        input.jobTag?.let { field(JOBTAG_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.notificationChannel?.let { field(NOTIFICATIONCHANNEL_DESCRIPTOR, it, ::serializeNotificationChannelDocument) }
        input.outputConfig?.let { field(OUTPUTCONFIG_DESCRIPTOR, it, ::serializeOutputConfigDocument) }
        input.queriesConfig?.let { field(QUERIESCONFIG_DESCRIPTOR, it, ::serializeQueriesConfigDocument) }
    }
    return serializer.toByteArray()
}
