// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The S3 bucket name and file name that identifies the document.
 *
 * The AWS Region for the S3 bucket that contains the document must match the Region that you use for Amazon Textract operations.
 *
 * For Amazon Textract to process a file in an S3 bucket, the user must have permission to access the S3 bucket and file.
 */
public class S3Object private constructor(builder: Builder) {
    /**
     * The name of the S3 bucket. Note that the # character is not valid in the file name.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The file name of the input document. Synchronous operations can use image files that are in JPEG or PNG format. Asynchronous operations also support PDF and TIFF format files.
     */
    public val name: kotlin.String? = builder.name
    /**
     * If the bucket has versioning enabled, you can specify the object version.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.S3Object = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Object(")
        append("bucket=$bucket,")
        append("name=$name,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Object

        if (bucket != other.bucket) return false
        if (name != other.name) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.S3Object = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the S3 bucket. Note that the # character is not valid in the file name.
         */
        public var bucket: kotlin.String? = null
        /**
         * The file name of the input document. Synchronous operations can use image files that are in JPEG or PNG format. Asynchronous operations also support PDF and TIFF format files.
         */
        public var name: kotlin.String? = null
        /**
         * If the bucket has versioning enabled, you can specify the object version.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.S3Object) : this() {
            this.bucket = x.bucket
            this.name = x.name
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.S3Object = S3Object(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
