// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Each query contains the question you want to ask in the Text and the alias you want to associate.
 */
public class Query private constructor(builder: Builder) {
    /**
     * Alias attached to the query, for ease of location.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * Pages is a parameter that the user inputs to specify which pages to apply a query to. The following is a list of rules for using this parameter.
     * + If a page is not specified, it is set to `["1"]` by default.
     * + The following characters are allowed in the parameter's string: `0 1 2 3 4 5 6 7 8 9 - *`. No whitespace is allowed.
     * + When using * to indicate all pages, it must be the only element in the list.
     * + You can use page intervals, such as `[“1-3”, “1-1”, “4-*”]`. Where `*` indicates last page of document.
     * + Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
     */
    public val pages: List<String>? = builder.pages
    /**
     * Question that Amazon Textract will apply to the document. An example would be "What is the customer's SSN?"
     */
    public val text: kotlin.String = requireNotNull(builder.text) { "A non-null value must be provided for text" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.Query = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Query(")
        append("alias=$alias,")
        append("pages=$pages,")
        append("text=$text")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (pages?.hashCode() ?: 0)
        result = 31 * result + (text.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Query

        if (alias != other.alias) return false
        if (pages != other.pages) return false
        if (text != other.text) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.Query = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Alias attached to the query, for ease of location.
         */
        public var alias: kotlin.String? = null
        /**
         * Pages is a parameter that the user inputs to specify which pages to apply a query to. The following is a list of rules for using this parameter.
         * + If a page is not specified, it is set to `["1"]` by default.
         * + The following characters are allowed in the parameter's string: `0 1 2 3 4 5 6 7 8 9 - *`. No whitespace is allowed.
         * + When using * to indicate all pages, it must be the only element in the list.
         * + You can use page intervals, such as `[“1-3”, “1-1”, “4-*”]`. Where `*` indicates last page of document.
         * + Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
         */
        public var pages: List<String>? = null
        /**
         * Question that Amazon Textract will apply to the document. An example would be "What is the customer's SSN?"
         */
        public var text: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.Query) : this() {
            this.alias = x.alias
            this.pages = x.pages
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.Query = Query(this)

        internal fun correctErrors(): Builder {
            if (text == null) text = ""
            return this
        }
    }
}
