// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The class assigned to a Page object detected in an input document. Contains information regarding the predicted type/class of a document's page and the page number that the Page object was detected on.
 */
public class PageClassification private constructor(builder: Builder) {
    /**
     * The page number the value was detected on, relative to Amazon Textract's starting position.
     */
    public val pageNumber: List<Prediction> = requireNotNull(builder.pageNumber) { "A non-null value must be provided for pageNumber" }
    /**
     * The class, or document type, assigned to a detected Page object. The class, or document type, assigned to a detected Page object.
     */
    public val pageType: List<Prediction> = requireNotNull(builder.pageType) { "A non-null value must be provided for pageType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.PageClassification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PageClassification(")
        append("pageNumber=$pageNumber,")
        append("pageType=$pageType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = pageNumber.hashCode()
        result = 31 * result + (pageType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PageClassification

        if (pageNumber != other.pageNumber) return false
        if (pageType != other.pageType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.PageClassification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The page number the value was detected on, relative to Amazon Textract's starting position.
         */
        public var pageNumber: List<Prediction>? = null
        /**
         * The class, or document type, assigned to a detected Page object. The class, or document type, assigned to a detected Page object.
         */
        public var pageType: List<Prediction>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.PageClassification) : this() {
            this.pageNumber = x.pageNumber
            this.pageType = x.pageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.PageClassification = PageClassification(this)

        internal fun correctErrors(): Builder {
            if (pageNumber == null) pageNumber = emptyList()
            if (pageType == null) pageType = emptyList()
            return this
        }
    }
}
