// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The input document, either as bytes or as an S3 object.
 *
 * You pass image bytes to an Amazon Textract API operation by using the `Bytes` property. For example, you would use the `Bytes` property to pass a document loaded from a local file system. Image bytes passed by using the `Bytes` property must be base64 encoded. Your code might not need to encode document file bytes if you're using an AWS SDK to call Amazon Textract API operations.
 *
 * You pass images stored in an S3 bucket to an Amazon Textract API operation by using the `S3Object` property. Documents stored in an S3 bucket don't need to be base64 encoded.
 *
 * The AWS Region for the S3 bucket that contains the S3 object must match the AWS Region that you use for Amazon Textract operations.
 *
 * If you use the AWS CLI to call Amazon Textract operations, passing image bytes using the Bytes property isn't supported. You must first upload the document to an Amazon S3 bucket, and then call the operation using the S3Object property.
 *
 * For Amazon Textract to process an S3 object, the user must have permission to access the S3 object.
 */
public class Document private constructor(builder: Builder) {
    /**
     * A blob of base64-encoded document bytes. The maximum size of a document that's provided in a blob of bytes is 5 MB. The document bytes must be in PNG or JPEG format.
     *
     * If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes passed using the `Bytes` field.
     */
    public val bytes: kotlin.ByteArray? = builder.bytes
    /**
     * Identifies an S3 object as the document source. The maximum size of a document that's stored in an S3 bucket is 5 MB.
     */
    public val s3Object: aws.sdk.kotlin.services.textract.model.S3Object? = builder.s3Object

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.Document = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Document(")
        append("bytes=$bytes,")
        append("s3Object=$s3Object")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytes?.contentHashCode() ?: 0
        result = 31 * result + (s3Object?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Document

        if (bytes != null) {
            if (other.bytes == null) return false
            if (!bytes.contentEquals(other.bytes)) return false
        } else if (other.bytes != null) return false
        if (s3Object != other.s3Object) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.Document = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A blob of base64-encoded document bytes. The maximum size of a document that's provided in a blob of bytes is 5 MB. The document bytes must be in PNG or JPEG format.
         *
         * If you're using an AWS SDK to call Amazon Textract, you might not need to base64-encode image bytes passed using the `Bytes` field.
         */
        public var bytes: kotlin.ByteArray? = null
        /**
         * Identifies an S3 object as the document source. The maximum size of a document that's stored in an S3 bucket is 5 MB.
         */
        public var s3Object: aws.sdk.kotlin.services.textract.model.S3Object? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.Document) : this() {
            this.bytes = x.bytes
            this.s3Object = x.s3Object
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.Document = Document(this)

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.S3Object] inside the given [block]
         */
        public fun s3Object(block: aws.sdk.kotlin.services.textract.model.S3Object.Builder.() -> kotlin.Unit) {
            this.s3Object = aws.sdk.kotlin.services.textract.model.S3Object.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
