// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.serde

import aws.sdk.kotlin.services.textract.model.AnalyzeDocumentResponse
import aws.sdk.kotlin.services.textract.model.Block
import aws.sdk.kotlin.services.textract.model.DocumentMetadata
import aws.sdk.kotlin.services.textract.model.HumanLoopActivationOutput
import aws.sdk.kotlin.services.textract.model.TextractException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class AnalyzeDocumentOperationDeserializer: HttpDeserialize<AnalyzeDocumentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AnalyzeDocumentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAnalyzeDocumentError(context, call)
        }
        val builder = AnalyzeDocumentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAnalyzeDocumentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAnalyzeDocumentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TextractException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "HumanLoopQuotaExceededException" -> HumanLoopQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "BadDocumentException" -> BadDocumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "DocumentTooLargeException" -> DocumentTooLargeExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidS3ObjectException" -> InvalidS3ObjectExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedDocumentException" -> UnsupportedDocumentExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> TextractException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAnalyzeDocumentOperationBody(builder: AnalyzeDocumentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANALYZEDOCUMENTMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AnalyzeDocumentModelVersion"))
    val BLOCKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Blocks"))
    val DOCUMENTMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DocumentMetadata"))
    val HUMANLOOPACTIVATIONOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HumanLoopActivationOutput"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANALYZEDOCUMENTMODELVERSION_DESCRIPTOR)
        field(BLOCKS_DESCRIPTOR)
        field(DOCUMENTMETADATA_DESCRIPTOR)
        field(HUMANLOOPACTIVATIONOUTPUT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANALYZEDOCUMENTMODELVERSION_DESCRIPTOR.index -> builder.analyzeDocumentModelVersion = deserializeString()
                BLOCKS_DESCRIPTOR.index -> builder.blocks =
                    deserializer.deserializeList(BLOCKS_DESCRIPTOR) {
                        val col0 = mutableListOf<Block>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBlockDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DOCUMENTMETADATA_DESCRIPTOR.index -> builder.documentMetadata = deserializeDocumentMetadataDocument(deserializer)
                HUMANLOOPACTIVATIONOUTPUT_DESCRIPTOR.index -> builder.humanLoopActivationOutput = deserializeHumanLoopActivationOutputDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
