// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



/**
 * Information about how blocks are related to each other. A `Block` object contains 0 or more `Relation` objects in a list, `Relationships`. For more information, see Block.
 *
 * The `Type` element provides the type of the relationship for all blocks in the `IDs` array.
 */
public class Relationship private constructor(builder: Builder) {
    /**
     * An array of IDs for related blocks. You can get the type of the relationship from the `Type` element.
     */
    public val ids: List<String>? = builder.ids
    /**
     * The type of relationship between the blocks in the IDs array and the current block. The following list describes the relationship types that can be returned.
     * + *VALUE* - A list that contains the ID of the VALUE block that's associated with the KEY of a key-value pair.
     * + *CHILD* - A list of IDs that identify blocks found within the current block object. For example, WORD blocks have a CHILD relationship to the LINE block type.
     * + *MERGED_CELL* - A list of IDs that identify each of the MERGED_CELL block types in a table.
     * + *ANSWER* - A list that contains the ID of the QUERY_RESULT block that’s associated with the corresponding QUERY block.
     * + *TABLE* - A list of IDs that identify associated TABLE block types.
     * + *TABLE_TITLE* - A list that contains the ID for the TABLE_TITLE block type in a table.
     * + *TABLE_FOOTER* - A list of IDs that identify the TABLE_FOOTER block types in a table.
     */
    public val type: aws.sdk.kotlin.services.textract.model.RelationshipType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.Relationship = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Relationship(")
        append("ids=$ids,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ids?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Relationship

        if (ids != other.ids) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.Relationship = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of IDs for related blocks. You can get the type of the relationship from the `Type` element.
         */
        public var ids: List<String>? = null
        /**
         * The type of relationship between the blocks in the IDs array and the current block. The following list describes the relationship types that can be returned.
         * + *VALUE* - A list that contains the ID of the VALUE block that's associated with the KEY of a key-value pair.
         * + *CHILD* - A list of IDs that identify blocks found within the current block object. For example, WORD blocks have a CHILD relationship to the LINE block type.
         * + *MERGED_CELL* - A list of IDs that identify each of the MERGED_CELL block types in a table.
         * + *ANSWER* - A list that contains the ID of the QUERY_RESULT block that’s associated with the corresponding QUERY block.
         * + *TABLE* - A list of IDs that identify associated TABLE block types.
         * + *TABLE_TITLE* - A list that contains the ID for the TABLE_TITLE block type in a table.
         * + *TABLE_FOOTER* - A list of IDs that identify the TABLE_FOOTER block types in a table.
         */
        public var type: aws.sdk.kotlin.services.textract.model.RelationshipType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.Relationship) : this() {
            this.ids = x.ids
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.Relationship = Relationship(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
