// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



/**
 * The structure that lists each document processed in an AnalyzeID operation.
 */
public class IdentityDocument private constructor(builder: Builder) {
    /**
     * Individual word recognition, as returned by document detection.
     */
    public val blocks: List<Block>? = builder.blocks
    /**
     * Denotes the placement of a document in the IdentityDocument list. The first document is marked 1, the second 2 and so on.
     */
    public val documentIndex: kotlin.Int? = builder.documentIndex
    /**
     * The structure used to record information extracted from identity documents. Contains both normalized field and value of the extracted text.
     */
    public val identityDocumentFields: List<IdentityDocumentField>? = builder.identityDocumentFields

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.IdentityDocument = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityDocument(")
        append("blocks=$blocks,")
        append("documentIndex=$documentIndex,")
        append("identityDocumentFields=$identityDocumentFields")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blocks?.hashCode() ?: 0
        result = 31 * result + (documentIndex ?: 0)
        result = 31 * result + (identityDocumentFields?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityDocument

        if (blocks != other.blocks) return false
        if (documentIndex != other.documentIndex) return false
        if (identityDocumentFields != other.identityDocumentFields) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.IdentityDocument = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Individual word recognition, as returned by document detection.
         */
        public var blocks: List<Block>? = null
        /**
         * Denotes the placement of a document in the IdentityDocument list. The first document is marked 1, the second 2 and so on.
         */
        public var documentIndex: kotlin.Int? = null
        /**
         * The structure used to record information extracted from identity documents. Contains both normalized field and value of the extracted text.
         */
        public var identityDocumentFields: List<IdentityDocumentField>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.IdentityDocument) : this() {
            this.blocks = x.blocks
            this.documentIndex = x.documentIndex
            this.identityDocumentFields = x.identityDocumentFields
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.IdentityDocument = IdentityDocument(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
