// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



public class CreateAdapterVersionRequest private constructor(builder: Builder) {
    /**
     * A string containing a unique ID for the adapter that will receive a new version.
     */
    public val adapterId: kotlin.String? = builder.adapterId
    /**
     * Idempotent token is used to recognize the request. If the same token is used with multiple CreateAdapterVersion requests, the same session is returned. This token is employed to avoid unintentionally creating the same session multiple times.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Specifies a dataset used to train a new adapter version. Takes a ManifestS3Object as the value.
     */
    public val datasetConfig: aws.sdk.kotlin.services.textract.model.AdapterVersionDatasetConfig? = builder.datasetConfig
    /**
     * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Sets whether or not your output will go to a user created bucket. Used to set the name of the bucket, and the prefix on the output file.
     *
     * `OutputConfig` is an optional parameter which lets you adjust where your output will be placed. By default, Amazon Textract will store the results internally and can only be accessed by the Get API operations. With `OutputConfig` enabled, you can set the name of the bucket the output will be sent to the file prefix of the results where you can download your results. Additionally, you can set the `KMSKeyID` parameter to a customer master key (CMK) to encrypt your output. Without this parameter set Amazon Textract will encrypt server-side using the AWS managed CMK for Amazon S3.
     *
     * Decryption of Customer Content is necessary for processing of the documents by Amazon Textract. If your account is opted out under an AI services opt out policy then all unencrypted Customer Content is immediately and permanently deleted after the Customer Content has been processed by the service. No copy of of the output is retained by Amazon Textract. For information about how to opt out, see [ Managing AI services opt-out policy. ](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
     *
     * For more information on data privacy, see the [Data Privacy FAQ](https://aws.amazon.com/compliance/data-privacy-faq/).
     */
    public val outputConfig: aws.sdk.kotlin.services.textract.model.OutputConfig? = builder.outputConfig
    /**
     * A set of tags (key-value pairs) that you want to attach to the adapter version.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.CreateAdapterVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAdapterVersionRequest(")
        append("adapterId=$adapterId,")
        append("clientRequestToken=$clientRequestToken,")
        append("datasetConfig=$datasetConfig,")
        append("kmsKeyId=$kmsKeyId,")
        append("outputConfig=$outputConfig,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adapterId?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (datasetConfig?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAdapterVersionRequest

        if (adapterId != other.adapterId) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (datasetConfig != other.datasetConfig) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (outputConfig != other.outputConfig) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.CreateAdapterVersionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A string containing a unique ID for the adapter that will receive a new version.
         */
        public var adapterId: kotlin.String? = null
        /**
         * Idempotent token is used to recognize the request. If the same token is used with multiple CreateAdapterVersion requests, the same session is returned. This token is employed to avoid unintentionally creating the same session multiple times.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Specifies a dataset used to train a new adapter version. Takes a ManifestS3Object as the value.
         */
        public var datasetConfig: aws.sdk.kotlin.services.textract.model.AdapterVersionDatasetConfig? = null
        /**
         * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Sets whether or not your output will go to a user created bucket. Used to set the name of the bucket, and the prefix on the output file.
         *
         * `OutputConfig` is an optional parameter which lets you adjust where your output will be placed. By default, Amazon Textract will store the results internally and can only be accessed by the Get API operations. With `OutputConfig` enabled, you can set the name of the bucket the output will be sent to the file prefix of the results where you can download your results. Additionally, you can set the `KMSKeyID` parameter to a customer master key (CMK) to encrypt your output. Without this parameter set Amazon Textract will encrypt server-side using the AWS managed CMK for Amazon S3.
         *
         * Decryption of Customer Content is necessary for processing of the documents by Amazon Textract. If your account is opted out under an AI services opt out policy then all unencrypted Customer Content is immediately and permanently deleted after the Customer Content has been processed by the service. No copy of of the output is retained by Amazon Textract. For information about how to opt out, see [ Managing AI services opt-out policy. ](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
         *
         * For more information on data privacy, see the [Data Privacy FAQ](https://aws.amazon.com/compliance/data-privacy-faq/).
         */
        public var outputConfig: aws.sdk.kotlin.services.textract.model.OutputConfig? = null
        /**
         * A set of tags (key-value pairs) that you want to attach to the adapter version.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.CreateAdapterVersionRequest) : this() {
            this.adapterId = x.adapterId
            this.clientRequestToken = x.clientRequestToken
            this.datasetConfig = x.datasetConfig
            this.kmsKeyId = x.kmsKeyId
            this.outputConfig = x.outputConfig
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.CreateAdapterVersionRequest = CreateAdapterVersionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.AdapterVersionDatasetConfig] inside the given [block]
         */
        public fun datasetConfig(block: aws.sdk.kotlin.services.textract.model.AdapterVersionDatasetConfig.Builder.() -> kotlin.Unit) {
            this.datasetConfig = aws.sdk.kotlin.services.textract.model.AdapterVersionDatasetConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.OutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.textract.model.OutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.textract.model.OutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
