// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.textract.auth.DefaultTextractAuthSchemeProvider
import aws.sdk.kotlin.services.textract.auth.TextractAuthSchemeProvider
import aws.sdk.kotlin.services.textract.endpoints.DefaultTextractEndpointProvider
import aws.sdk.kotlin.services.textract.endpoints.TextractEndpointParameters
import aws.sdk.kotlin.services.textract.endpoints.TextractEndpointProvider
import aws.sdk.kotlin.services.textract.model.AnalyzeDocumentRequest
import aws.sdk.kotlin.services.textract.model.AnalyzeDocumentResponse
import aws.sdk.kotlin.services.textract.model.AnalyzeExpenseRequest
import aws.sdk.kotlin.services.textract.model.AnalyzeExpenseResponse
import aws.sdk.kotlin.services.textract.model.AnalyzeIdRequest
import aws.sdk.kotlin.services.textract.model.AnalyzeIdResponse
import aws.sdk.kotlin.services.textract.model.CreateAdapterRequest
import aws.sdk.kotlin.services.textract.model.CreateAdapterResponse
import aws.sdk.kotlin.services.textract.model.CreateAdapterVersionRequest
import aws.sdk.kotlin.services.textract.model.CreateAdapterVersionResponse
import aws.sdk.kotlin.services.textract.model.DeleteAdapterRequest
import aws.sdk.kotlin.services.textract.model.DeleteAdapterResponse
import aws.sdk.kotlin.services.textract.model.DeleteAdapterVersionRequest
import aws.sdk.kotlin.services.textract.model.DeleteAdapterVersionResponse
import aws.sdk.kotlin.services.textract.model.DetectDocumentTextRequest
import aws.sdk.kotlin.services.textract.model.DetectDocumentTextResponse
import aws.sdk.kotlin.services.textract.model.GetAdapterRequest
import aws.sdk.kotlin.services.textract.model.GetAdapterResponse
import aws.sdk.kotlin.services.textract.model.GetAdapterVersionRequest
import aws.sdk.kotlin.services.textract.model.GetAdapterVersionResponse
import aws.sdk.kotlin.services.textract.model.GetDocumentAnalysisRequest
import aws.sdk.kotlin.services.textract.model.GetDocumentAnalysisResponse
import aws.sdk.kotlin.services.textract.model.GetDocumentTextDetectionRequest
import aws.sdk.kotlin.services.textract.model.GetDocumentTextDetectionResponse
import aws.sdk.kotlin.services.textract.model.GetExpenseAnalysisRequest
import aws.sdk.kotlin.services.textract.model.GetExpenseAnalysisResponse
import aws.sdk.kotlin.services.textract.model.GetLendingAnalysisRequest
import aws.sdk.kotlin.services.textract.model.GetLendingAnalysisResponse
import aws.sdk.kotlin.services.textract.model.GetLendingAnalysisSummaryRequest
import aws.sdk.kotlin.services.textract.model.GetLendingAnalysisSummaryResponse
import aws.sdk.kotlin.services.textract.model.ListAdapterVersionsRequest
import aws.sdk.kotlin.services.textract.model.ListAdapterVersionsResponse
import aws.sdk.kotlin.services.textract.model.ListAdaptersRequest
import aws.sdk.kotlin.services.textract.model.ListAdaptersResponse
import aws.sdk.kotlin.services.textract.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.textract.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.textract.model.StartDocumentAnalysisRequest
import aws.sdk.kotlin.services.textract.model.StartDocumentAnalysisResponse
import aws.sdk.kotlin.services.textract.model.StartDocumentTextDetectionRequest
import aws.sdk.kotlin.services.textract.model.StartDocumentTextDetectionResponse
import aws.sdk.kotlin.services.textract.model.StartExpenseAnalysisRequest
import aws.sdk.kotlin.services.textract.model.StartExpenseAnalysisResponse
import aws.sdk.kotlin.services.textract.model.StartLendingAnalysisRequest
import aws.sdk.kotlin.services.textract.model.StartLendingAnalysisResponse
import aws.sdk.kotlin.services.textract.model.TagResourceRequest
import aws.sdk.kotlin.services.textract.model.TagResourceResponse
import aws.sdk.kotlin.services.textract.model.UntagResourceRequest
import aws.sdk.kotlin.services.textract.model.UntagResourceResponse
import aws.sdk.kotlin.services.textract.model.UpdateAdapterRequest
import aws.sdk.kotlin.services.textract.model.UpdateAdapterResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Textract"
public const val SdkVersion: String = "1.0.43"
public const val ServiceApiVersion: String = "2018-06-27"

/**
 * Amazon Textract detects and analyzes text in documents and converts it into machine-readable text. This is the API reference documentation for Amazon Textract.
 */
public interface TextractClient : SdkClient {
    /**
     * TextractClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, TextractClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Textract",
                "TEXTRACT",
                "textract",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, TextractClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): TextractClient = DefaultTextractClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: TextractEndpointProvider = builder.endpointProvider ?: DefaultTextractEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: TextractAuthSchemeProvider = builder.authSchemeProvider ?: DefaultTextractAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Textract"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: TextractEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: TextractAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Analyzes an input document for relationships between detected items.
     *
     * The types of information returned are as follows:
     * + Form data (key-value pairs). The related information is returned in two Block objects, each of type `KEY_VALUE_SET`: a KEY `Block` object and a VALUE `Block` object. For example, *Name: Ana Silva Carolina* contains a key and value. *Name:* is the key. *Ana Silva Carolina* is the value.
     * + Table and table cell data. A TABLE `Block` object contains information about a detected table. A CELL `Block` object is returned for each cell in a table.
     * + Lines and words of text. A LINE `Block` object contains one or more WORD `Block` objects. All lines and words that are detected in the document are returned (including text that doesn't have a relationship with the value of `FeatureTypes`).
     * + Signatures. A SIGNATURE `Block` object contains the location information of a signature in a document. If used in conjunction with forms or tables, a signature can be given a Key-Value pairing or be detected in the cell of a table.
     * + Query. A QUERY Block object contains the query text, alias and link to the associated Query results block object.
     * + Query Result. A QUERY_RESULT Block object contains the answer to the query and an ID that connects it to the query asked. This Block also contains a confidence score.
     *
     * Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in tables. A SELECTION_ELEMENT `Block` object contains information about a selection element, including the selection status.
     *
     * You can choose which type of analysis to perform by specifying the `FeatureTypes` list.
     *
     * The output is returned in a list of `Block` objects.
     *
     * `AnalyzeDocument` is a synchronous operation. To analyze documents asynchronously, use StartDocumentAnalysis.
     *
     * For more information, see [Document Text Analysis](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
     */
    public suspend fun analyzeDocument(input: AnalyzeDocumentRequest): AnalyzeDocumentResponse

    /**
     * `AnalyzeExpense` synchronously analyzes an input document for financially related relationships between text.
     *
     * Information is returned as `ExpenseDocuments` and seperated as follows:
     * + `LineItemGroups`- A data set containing `LineItems` which store information about the lines of text, such as an item purchased and its price on a receipt.
     * + `SummaryFields`- Contains all other information a receipt, such as header information or the vendors name.
     */
    public suspend fun analyzeExpense(input: AnalyzeExpenseRequest): AnalyzeExpenseResponse

    /**
     * Analyzes identity documents for relevant information. This information is extracted and returned as `IdentityDocumentFields`, which records both the normalized field and value of the extracted text. Unlike other Amazon Textract operations, `AnalyzeID` doesn't return any Geometry data.
     */
    public suspend fun analyzeId(input: AnalyzeIdRequest): AnalyzeIdResponse

    /**
     * Creates an adapter, which can be fine-tuned for enhanced performance on user provided documents. Takes an AdapterName and FeatureType. Currently the only supported feature type is `QUERIES`. You can also provide a Description, Tags, and a ClientRequestToken. You can choose whether or not the adapter should be AutoUpdated with the AutoUpdate argument. By default, AutoUpdate is set to DISABLED.
     */
    public suspend fun createAdapter(input: CreateAdapterRequest): CreateAdapterResponse

    /**
     * Creates a new version of an adapter. Operates on a provided AdapterId and a specified dataset provided via the DatasetConfig argument. Requires that you specify an Amazon S3 bucket with the OutputConfig argument. You can provide an optional KMSKeyId, an optional ClientRequestToken, and optional tags.
     */
    public suspend fun createAdapterVersion(input: CreateAdapterVersionRequest): CreateAdapterVersionResponse

    /**
     * Deletes an Amazon Textract adapter. Takes an AdapterId and deletes the adapter specified by the ID.
     */
    public suspend fun deleteAdapter(input: DeleteAdapterRequest): DeleteAdapterResponse

    /**
     * Deletes an Amazon Textract adapter version. Requires that you specify both an AdapterId and a AdapterVersion. Deletes the adapter version specified by the AdapterId and the AdapterVersion.
     */
    public suspend fun deleteAdapterVersion(input: DeleteAdapterVersionRequest): DeleteAdapterVersionResponse

    /**
     * Detects text in the input document. Amazon Textract can detect lines of text and the words that make up a line of text. The input document must be in one of the following image formats: JPEG, PNG, PDF, or TIFF. `DetectDocumentText` returns the detected text in an array of Block objects.
     *
     * Each document page has as an associated `Block` of type PAGE. Each PAGE `Block` object is the parent of LINE `Block` objects that represent the lines of detected text on a page. A LINE `Block` object is a parent for each word that makes up the line. Words are represented by `Block` objects of type WORD.
     *
     * `DetectDocumentText` is a synchronous operation. To analyze documents asynchronously, use StartDocumentTextDetection.
     *
     * For more information, see [Document Text Detection](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
     */
    public suspend fun detectDocumentText(input: DetectDocumentTextRequest): DetectDocumentTextResponse

    /**
     * Gets configuration information for an adapter specified by an AdapterId, returning information on AdapterName, Description, CreationTime, AutoUpdate status, and FeatureTypes.
     */
    public suspend fun getAdapter(input: GetAdapterRequest): GetAdapterResponse

    /**
     * Gets configuration information for the specified adapter version, including: AdapterId, AdapterVersion, FeatureTypes, Status, StatusMessage, DatasetConfig, KMSKeyId, OutputConfig, Tags and EvaluationMetrics.
     */
    public suspend fun getAdapterVersion(input: GetAdapterVersionRequest): GetAdapterVersionResponse

    /**
     * Gets the results for an Amazon Textract asynchronous operation that analyzes text in a document.
     *
     * You start asynchronous text analysis by calling StartDocumentAnalysis, which returns a job identifier (`JobId`). When the text analysis operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to `StartDocumentAnalysis`. To get the results of the text-detection operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call `GetDocumentAnalysis`, and pass the job identifier (`JobId`) from the initial call to `StartDocumentAnalysis`.
     *
     * `GetDocumentAnalysis` returns an array of Block objects. The following types of information are returned:
     * + Form data (key-value pairs). The related information is returned in two Block objects, each of type `KEY_VALUE_SET`: a KEY `Block` object and a VALUE `Block` object. For example, *Name: Ana Silva Carolina* contains a key and value. *Name:* is the key. *Ana Silva Carolina* is the value.
     * + Table and table cell data. A TABLE `Block` object contains information about a detected table. A CELL `Block` object is returned for each cell in a table.
     * + Lines and words of text. A LINE `Block` object contains one or more WORD `Block` objects. All lines and words that are detected in the document are returned (including text that doesn't have a relationship with the value of the `StartDocumentAnalysis``FeatureTypes` input parameter).
     * + Query. A QUERY Block object contains the query text, alias and link to the associated Query results block object.
     * + Query Results. A QUERY_RESULT Block object contains the answer to the query and an ID that connects it to the query asked. This Block also contains a confidence score.
     *
     * While processing a document with queries, look out for `INVALID_REQUEST_PARAMETERS` output. This indicates that either the per page query limit has been exceeded or that the operation is trying to query a page in the document which doesn’t exist.
     *
     * Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in tables. A SELECTION_ELEMENT `Block` object contains information about a selection element, including the selection status.
     *
     * Use the `MaxResults` parameter to limit the number of blocks that are returned. If there are more results than specified in `MaxResults`, the value of `NextToken` in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call `GetDocumentAnalysis`, and populate the `NextToken` request parameter with the token value that's returned from the previous call to `GetDocumentAnalysis`.
     *
     * For more information, see [Document Text Analysis](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
     */
    public suspend fun getDocumentAnalysis(input: GetDocumentAnalysisRequest): GetDocumentAnalysisResponse

    /**
     * Gets the results for an Amazon Textract asynchronous operation that detects text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.
     *
     * You start asynchronous text detection by calling StartDocumentTextDetection, which returns a job identifier (`JobId`). When the text detection operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to `StartDocumentTextDetection`. To get the results of the text-detection operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call `GetDocumentTextDetection`, and pass the job identifier (`JobId`) from the initial call to `StartDocumentTextDetection`.
     *
     * `GetDocumentTextDetection` returns an array of Block objects.
     *
     * Each document page has as an associated `Block` of type PAGE. Each PAGE `Block` object is the parent of LINE `Block` objects that represent the lines of detected text on a page. A LINE `Block` object is a parent for each word that makes up the line. Words are represented by `Block` objects of type WORD.
     *
     * Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than specified in `MaxResults`, the value of `NextToken` in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call `GetDocumentTextDetection`, and populate the `NextToken` request parameter with the token value that's returned from the previous call to `GetDocumentTextDetection`.
     *
     * For more information, see [Document Text Detection](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
     */
    public suspend fun getDocumentTextDetection(input: GetDocumentTextDetectionRequest): GetDocumentTextDetectionResponse

    /**
     * Gets the results for an Amazon Textract asynchronous operation that analyzes invoices and receipts. Amazon Textract finds contact information, items purchased, and vendor name, from input invoices and receipts.
     *
     * You start asynchronous invoice/receipt analysis by calling StartExpenseAnalysis, which returns a job identifier (`JobId`). Upon completion of the invoice/receipt analysis, Amazon Textract publishes the completion status to the Amazon Simple Notification Service (Amazon SNS) topic. This topic must be registered in the initial call to `StartExpenseAnalysis`. To get the results of the invoice/receipt analysis operation, first ensure that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call `GetExpenseAnalysis`, and pass the job identifier (`JobId`) from the initial call to `StartExpenseAnalysis`.
     *
     * Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than specified in `MaxResults`, the value of `NextToken` in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call `GetExpenseAnalysis`, and populate the `NextToken` request parameter with the token value that's returned from the previous call to `GetExpenseAnalysis`.
     *
     * For more information, see [Analyzing Invoices and Receipts](https://docs.aws.amazon.com/textract/latest/dg/invoices-receipts.html).
     */
    public suspend fun getExpenseAnalysis(input: GetExpenseAnalysisRequest): GetExpenseAnalysisResponse

    /**
     * Gets the results for an Amazon Textract asynchronous operation that analyzes text in a lending document.
     *
     * You start asynchronous text analysis by calling `StartLendingAnalysis`, which returns a job identifier (`JobId`). When the text analysis operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to `StartLendingAnalysis`.
     *
     * To get the results of the text analysis operation, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so, call GetLendingAnalysis, and pass the job identifier (`JobId`) from the initial call to `StartLendingAnalysis`.
     */
    public suspend fun getLendingAnalysis(input: GetLendingAnalysisRequest): GetLendingAnalysisResponse

    /**
     * Gets summarized results for the `StartLendingAnalysis` operation, which analyzes text in a lending document. The returned summary consists of information about documents grouped together by a common document type. Information like detected signatures, page numbers, and split documents is returned with respect to the type of grouped document.
     *
     * You start asynchronous text analysis by calling `StartLendingAnalysis`, which returns a job identifier (`JobId`). When the text analysis operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to `StartLendingAnalysis`.
     *
     * To get the results of the text analysis operation, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so, call `GetLendingAnalysisSummary`, and pass the job identifier (`JobId`) from the initial call to `StartLendingAnalysis`.
     */
    public suspend fun getLendingAnalysisSummary(input: GetLendingAnalysisSummaryRequest): GetLendingAnalysisSummaryResponse

    /**
     * List all version of an adapter that meet the specified filtration criteria.
     */
    public suspend fun listAdapterVersions(input: ListAdapterVersionsRequest = ListAdapterVersionsRequest { }): ListAdapterVersionsResponse

    /**
     * Lists all adapters that match the specified filtration criteria.
     */
    public suspend fun listAdapters(input: ListAdaptersRequest = ListAdaptersRequest { }): ListAdaptersResponse

    /**
     * Lists all tags for an Amazon Textract resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts the asynchronous analysis of an input document for relationships between detected items such as key-value pairs, tables, and selection elements.
     *
     * `StartDocumentAnalysis` can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The documents are stored in an Amazon S3 bucket. Use DocumentLocation to specify the bucket name and file name of the document.
     *
     * `StartDocumentAnalysis` returns a job identifier (`JobId`) that you use to get the results of the operation. When text analysis is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you specify in `NotificationChannel`. To get the results of the text analysis operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call GetDocumentAnalysis, and pass the job identifier (`JobId`) from the initial call to `StartDocumentAnalysis`.
     *
     * For more information, see [Document Text Analysis](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
     */
    public suspend fun startDocumentAnalysis(input: StartDocumentAnalysisRequest): StartDocumentAnalysisResponse

    /**
     * Starts the asynchronous detection of text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.
     *
     * `StartDocumentTextDetection` can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The documents are stored in an Amazon S3 bucket. Use DocumentLocation to specify the bucket name and file name of the document.
     *
     * `StartTextDetection` returns a job identifier (`JobId`) that you use to get the results of the operation. When text detection is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you specify in `NotificationChannel`. To get the results of the text detection operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call GetDocumentTextDetection, and pass the job identifier (`JobId`) from the initial call to `StartDocumentTextDetection`.
     *
     * For more information, see [Document Text Detection](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
     */
    public suspend fun startDocumentTextDetection(input: StartDocumentTextDetectionRequest): StartDocumentTextDetectionResponse

    /**
     * Starts the asynchronous analysis of invoices or receipts for data like contact information, items purchased, and vendor names.
     *
     * `StartExpenseAnalysis` can analyze text in documents that are in JPEG, PNG, and PDF format. The documents must be stored in an Amazon S3 bucket. Use the DocumentLocation parameter to specify the name of your S3 bucket and the name of the document in that bucket.
     *
     * `StartExpenseAnalysis` returns a job identifier (`JobId`) that you will provide to `GetExpenseAnalysis` to retrieve the results of the operation. When the analysis of the input invoices/receipts is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you provide to the `NotificationChannel`. To obtain the results of the invoice and receipt analysis operation, ensure that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call GetExpenseAnalysis, and pass the job identifier (`JobId`) that was returned by your call to `StartExpenseAnalysis`.
     *
     * For more information, see [Analyzing Invoices and Receipts](https://docs.aws.amazon.com/textract/latest/dg/invoice-receipts.html).
     */
    public suspend fun startExpenseAnalysis(input: StartExpenseAnalysisRequest): StartExpenseAnalysisResponse

    /**
     * Starts the classification and analysis of an input document. `StartLendingAnalysis` initiates the classification and analysis of a packet of lending documents. `StartLendingAnalysis` operates on a document file located in an Amazon S3 bucket.
     *
     * `StartLendingAnalysis` can analyze text in documents that are in one of the following formats: JPEG, PNG, TIFF, PDF. Use `DocumentLocation` to specify the bucket name and the file name of the document.
     *
     * `StartLendingAnalysis` returns a job identifier (`JobId`) that you use to get the results of the operation. When the text analysis is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you specify in `NotificationChannel`. To get the results of the text analysis operation, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If the status is SUCCEEDED you can call either `GetLendingAnalysis` or `GetLendingAnalysisSummary` and provide the `JobId` to obtain the results of the analysis.
     *
     * If using `OutputConfig` to specify an Amazon S3 bucket, the output will be contained within the specified prefix in a directory labeled with the job-id. In the directory there are 3 sub-directories:
     * + detailedResponse (contains the GetLendingAnalysis response)
     * + summaryResponse (for the GetLendingAnalysisSummary response)
     * + splitDocuments (documents split across logical boundaries)
     */
    public suspend fun startLendingAnalysis(input: StartLendingAnalysisRequest): StartLendingAnalysisResponse

    /**
     * Adds one or more tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes any tags with the specified keys from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update the configuration for an adapter. FeatureTypes configurations cannot be updated. At least one new parameter must be specified as an argument.
     */
    public suspend fun updateAdapter(input: UpdateAdapterRequest): UpdateAdapterResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun TextractClient.withConfig(block: TextractClient.Config.Builder.() -> Unit): TextractClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultTextractClient(newConfig)
}

/**
 * Analyzes an input document for relationships between detected items.
 *
 * The types of information returned are as follows:
 * + Form data (key-value pairs). The related information is returned in two Block objects, each of type `KEY_VALUE_SET`: a KEY `Block` object and a VALUE `Block` object. For example, *Name: Ana Silva Carolina* contains a key and value. *Name:* is the key. *Ana Silva Carolina* is the value.
 * + Table and table cell data. A TABLE `Block` object contains information about a detected table. A CELL `Block` object is returned for each cell in a table.
 * + Lines and words of text. A LINE `Block` object contains one or more WORD `Block` objects. All lines and words that are detected in the document are returned (including text that doesn't have a relationship with the value of `FeatureTypes`).
 * + Signatures. A SIGNATURE `Block` object contains the location information of a signature in a document. If used in conjunction with forms or tables, a signature can be given a Key-Value pairing or be detected in the cell of a table.
 * + Query. A QUERY Block object contains the query text, alias and link to the associated Query results block object.
 * + Query Result. A QUERY_RESULT Block object contains the answer to the query and an ID that connects it to the query asked. This Block also contains a confidence score.
 *
 * Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in tables. A SELECTION_ELEMENT `Block` object contains information about a selection element, including the selection status.
 *
 * You can choose which type of analysis to perform by specifying the `FeatureTypes` list.
 *
 * The output is returned in a list of `Block` objects.
 *
 * `AnalyzeDocument` is a synchronous operation. To analyze documents asynchronously, use StartDocumentAnalysis.
 *
 * For more information, see [Document Text Analysis](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
 */
public suspend inline fun TextractClient.analyzeDocument(crossinline block: AnalyzeDocumentRequest.Builder.() -> Unit): AnalyzeDocumentResponse = analyzeDocument(AnalyzeDocumentRequest.Builder().apply(block).build())

/**
 * `AnalyzeExpense` synchronously analyzes an input document for financially related relationships between text.
 *
 * Information is returned as `ExpenseDocuments` and seperated as follows:
 * + `LineItemGroups`- A data set containing `LineItems` which store information about the lines of text, such as an item purchased and its price on a receipt.
 * + `SummaryFields`- Contains all other information a receipt, such as header information or the vendors name.
 */
public suspend inline fun TextractClient.analyzeExpense(crossinline block: AnalyzeExpenseRequest.Builder.() -> Unit): AnalyzeExpenseResponse = analyzeExpense(AnalyzeExpenseRequest.Builder().apply(block).build())

/**
 * Analyzes identity documents for relevant information. This information is extracted and returned as `IdentityDocumentFields`, which records both the normalized field and value of the extracted text. Unlike other Amazon Textract operations, `AnalyzeID` doesn't return any Geometry data.
 */
public suspend inline fun TextractClient.analyzeId(crossinline block: AnalyzeIdRequest.Builder.() -> Unit): AnalyzeIdResponse = analyzeId(AnalyzeIdRequest.Builder().apply(block).build())

/**
 * Creates an adapter, which can be fine-tuned for enhanced performance on user provided documents. Takes an AdapterName and FeatureType. Currently the only supported feature type is `QUERIES`. You can also provide a Description, Tags, and a ClientRequestToken. You can choose whether or not the adapter should be AutoUpdated with the AutoUpdate argument. By default, AutoUpdate is set to DISABLED.
 */
public suspend inline fun TextractClient.createAdapter(crossinline block: CreateAdapterRequest.Builder.() -> Unit): CreateAdapterResponse = createAdapter(CreateAdapterRequest.Builder().apply(block).build())

/**
 * Creates a new version of an adapter. Operates on a provided AdapterId and a specified dataset provided via the DatasetConfig argument. Requires that you specify an Amazon S3 bucket with the OutputConfig argument. You can provide an optional KMSKeyId, an optional ClientRequestToken, and optional tags.
 */
public suspend inline fun TextractClient.createAdapterVersion(crossinline block: CreateAdapterVersionRequest.Builder.() -> Unit): CreateAdapterVersionResponse = createAdapterVersion(CreateAdapterVersionRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Textract adapter. Takes an AdapterId and deletes the adapter specified by the ID.
 */
public suspend inline fun TextractClient.deleteAdapter(crossinline block: DeleteAdapterRequest.Builder.() -> Unit): DeleteAdapterResponse = deleteAdapter(DeleteAdapterRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Textract adapter version. Requires that you specify both an AdapterId and a AdapterVersion. Deletes the adapter version specified by the AdapterId and the AdapterVersion.
 */
public suspend inline fun TextractClient.deleteAdapterVersion(crossinline block: DeleteAdapterVersionRequest.Builder.() -> Unit): DeleteAdapterVersionResponse = deleteAdapterVersion(DeleteAdapterVersionRequest.Builder().apply(block).build())

/**
 * Detects text in the input document. Amazon Textract can detect lines of text and the words that make up a line of text. The input document must be in one of the following image formats: JPEG, PNG, PDF, or TIFF. `DetectDocumentText` returns the detected text in an array of Block objects.
 *
 * Each document page has as an associated `Block` of type PAGE. Each PAGE `Block` object is the parent of LINE `Block` objects that represent the lines of detected text on a page. A LINE `Block` object is a parent for each word that makes up the line. Words are represented by `Block` objects of type WORD.
 *
 * `DetectDocumentText` is a synchronous operation. To analyze documents asynchronously, use StartDocumentTextDetection.
 *
 * For more information, see [Document Text Detection](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
 */
public suspend inline fun TextractClient.detectDocumentText(crossinline block: DetectDocumentTextRequest.Builder.() -> Unit): DetectDocumentTextResponse = detectDocumentText(DetectDocumentTextRequest.Builder().apply(block).build())

/**
 * Gets configuration information for an adapter specified by an AdapterId, returning information on AdapterName, Description, CreationTime, AutoUpdate status, and FeatureTypes.
 */
public suspend inline fun TextractClient.getAdapter(crossinline block: GetAdapterRequest.Builder.() -> Unit): GetAdapterResponse = getAdapter(GetAdapterRequest.Builder().apply(block).build())

/**
 * Gets configuration information for the specified adapter version, including: AdapterId, AdapterVersion, FeatureTypes, Status, StatusMessage, DatasetConfig, KMSKeyId, OutputConfig, Tags and EvaluationMetrics.
 */
public suspend inline fun TextractClient.getAdapterVersion(crossinline block: GetAdapterVersionRequest.Builder.() -> Unit): GetAdapterVersionResponse = getAdapterVersion(GetAdapterVersionRequest.Builder().apply(block).build())

/**
 * Gets the results for an Amazon Textract asynchronous operation that analyzes text in a document.
 *
 * You start asynchronous text analysis by calling StartDocumentAnalysis, which returns a job identifier (`JobId`). When the text analysis operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to `StartDocumentAnalysis`. To get the results of the text-detection operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call `GetDocumentAnalysis`, and pass the job identifier (`JobId`) from the initial call to `StartDocumentAnalysis`.
 *
 * `GetDocumentAnalysis` returns an array of Block objects. The following types of information are returned:
 * + Form data (key-value pairs). The related information is returned in two Block objects, each of type `KEY_VALUE_SET`: a KEY `Block` object and a VALUE `Block` object. For example, *Name: Ana Silva Carolina* contains a key and value. *Name:* is the key. *Ana Silva Carolina* is the value.
 * + Table and table cell data. A TABLE `Block` object contains information about a detected table. A CELL `Block` object is returned for each cell in a table.
 * + Lines and words of text. A LINE `Block` object contains one or more WORD `Block` objects. All lines and words that are detected in the document are returned (including text that doesn't have a relationship with the value of the `StartDocumentAnalysis``FeatureTypes` input parameter).
 * + Query. A QUERY Block object contains the query text, alias and link to the associated Query results block object.
 * + Query Results. A QUERY_RESULT Block object contains the answer to the query and an ID that connects it to the query asked. This Block also contains a confidence score.
 *
 * While processing a document with queries, look out for `INVALID_REQUEST_PARAMETERS` output. This indicates that either the per page query limit has been exceeded or that the operation is trying to query a page in the document which doesn’t exist.
 *
 * Selection elements such as check boxes and option buttons (radio buttons) can be detected in form data and in tables. A SELECTION_ELEMENT `Block` object contains information about a selection element, including the selection status.
 *
 * Use the `MaxResults` parameter to limit the number of blocks that are returned. If there are more results than specified in `MaxResults`, the value of `NextToken` in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call `GetDocumentAnalysis`, and populate the `NextToken` request parameter with the token value that's returned from the previous call to `GetDocumentAnalysis`.
 *
 * For more information, see [Document Text Analysis](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
 */
public suspend inline fun TextractClient.getDocumentAnalysis(crossinline block: GetDocumentAnalysisRequest.Builder.() -> Unit): GetDocumentAnalysisResponse = getDocumentAnalysis(GetDocumentAnalysisRequest.Builder().apply(block).build())

/**
 * Gets the results for an Amazon Textract asynchronous operation that detects text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.
 *
 * You start asynchronous text detection by calling StartDocumentTextDetection, which returns a job identifier (`JobId`). When the text detection operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to `StartDocumentTextDetection`. To get the results of the text-detection operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call `GetDocumentTextDetection`, and pass the job identifier (`JobId`) from the initial call to `StartDocumentTextDetection`.
 *
 * `GetDocumentTextDetection` returns an array of Block objects.
 *
 * Each document page has as an associated `Block` of type PAGE. Each PAGE `Block` object is the parent of LINE `Block` objects that represent the lines of detected text on a page. A LINE `Block` object is a parent for each word that makes up the line. Words are represented by `Block` objects of type WORD.
 *
 * Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than specified in `MaxResults`, the value of `NextToken` in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call `GetDocumentTextDetection`, and populate the `NextToken` request parameter with the token value that's returned from the previous call to `GetDocumentTextDetection`.
 *
 * For more information, see [Document Text Detection](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
 */
public suspend inline fun TextractClient.getDocumentTextDetection(crossinline block: GetDocumentTextDetectionRequest.Builder.() -> Unit): GetDocumentTextDetectionResponse = getDocumentTextDetection(GetDocumentTextDetectionRequest.Builder().apply(block).build())

/**
 * Gets the results for an Amazon Textract asynchronous operation that analyzes invoices and receipts. Amazon Textract finds contact information, items purchased, and vendor name, from input invoices and receipts.
 *
 * You start asynchronous invoice/receipt analysis by calling StartExpenseAnalysis, which returns a job identifier (`JobId`). Upon completion of the invoice/receipt analysis, Amazon Textract publishes the completion status to the Amazon Simple Notification Service (Amazon SNS) topic. This topic must be registered in the initial call to `StartExpenseAnalysis`. To get the results of the invoice/receipt analysis operation, first ensure that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call `GetExpenseAnalysis`, and pass the job identifier (`JobId`) from the initial call to `StartExpenseAnalysis`.
 *
 * Use the MaxResults parameter to limit the number of blocks that are returned. If there are more results than specified in `MaxResults`, the value of `NextToken` in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call `GetExpenseAnalysis`, and populate the `NextToken` request parameter with the token value that's returned from the previous call to `GetExpenseAnalysis`.
 *
 * For more information, see [Analyzing Invoices and Receipts](https://docs.aws.amazon.com/textract/latest/dg/invoices-receipts.html).
 */
public suspend inline fun TextractClient.getExpenseAnalysis(crossinline block: GetExpenseAnalysisRequest.Builder.() -> Unit): GetExpenseAnalysisResponse = getExpenseAnalysis(GetExpenseAnalysisRequest.Builder().apply(block).build())

/**
 * Gets the results for an Amazon Textract asynchronous operation that analyzes text in a lending document.
 *
 * You start asynchronous text analysis by calling `StartLendingAnalysis`, which returns a job identifier (`JobId`). When the text analysis operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to `StartLendingAnalysis`.
 *
 * To get the results of the text analysis operation, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so, call GetLendingAnalysis, and pass the job identifier (`JobId`) from the initial call to `StartLendingAnalysis`.
 */
public suspend inline fun TextractClient.getLendingAnalysis(crossinline block: GetLendingAnalysisRequest.Builder.() -> Unit): GetLendingAnalysisResponse = getLendingAnalysis(GetLendingAnalysisRequest.Builder().apply(block).build())

/**
 * Gets summarized results for the `StartLendingAnalysis` operation, which analyzes text in a lending document. The returned summary consists of information about documents grouped together by a common document type. Information like detected signatures, page numbers, and split documents is returned with respect to the type of grouped document.
 *
 * You start asynchronous text analysis by calling `StartLendingAnalysis`, which returns a job identifier (`JobId`). When the text analysis operation finishes, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that's registered in the initial call to `StartLendingAnalysis`.
 *
 * To get the results of the text analysis operation, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so, call `GetLendingAnalysisSummary`, and pass the job identifier (`JobId`) from the initial call to `StartLendingAnalysis`.
 */
public suspend inline fun TextractClient.getLendingAnalysisSummary(crossinline block: GetLendingAnalysisSummaryRequest.Builder.() -> Unit): GetLendingAnalysisSummaryResponse = getLendingAnalysisSummary(GetLendingAnalysisSummaryRequest.Builder().apply(block).build())

/**
 * List all version of an adapter that meet the specified filtration criteria.
 */
public suspend inline fun TextractClient.listAdapterVersions(crossinline block: ListAdapterVersionsRequest.Builder.() -> Unit): ListAdapterVersionsResponse = listAdapterVersions(ListAdapterVersionsRequest.Builder().apply(block).build())

/**
 * Lists all adapters that match the specified filtration criteria.
 */
public suspend inline fun TextractClient.listAdapters(crossinline block: ListAdaptersRequest.Builder.() -> Unit): ListAdaptersResponse = listAdapters(ListAdaptersRequest.Builder().apply(block).build())

/**
 * Lists all tags for an Amazon Textract resource.
 */
public suspend inline fun TextractClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts the asynchronous analysis of an input document for relationships between detected items such as key-value pairs, tables, and selection elements.
 *
 * `StartDocumentAnalysis` can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The documents are stored in an Amazon S3 bucket. Use DocumentLocation to specify the bucket name and file name of the document.
 *
 * `StartDocumentAnalysis` returns a job identifier (`JobId`) that you use to get the results of the operation. When text analysis is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you specify in `NotificationChannel`. To get the results of the text analysis operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call GetDocumentAnalysis, and pass the job identifier (`JobId`) from the initial call to `StartDocumentAnalysis`.
 *
 * For more information, see [Document Text Analysis](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
 */
public suspend inline fun TextractClient.startDocumentAnalysis(crossinline block: StartDocumentAnalysisRequest.Builder.() -> Unit): StartDocumentAnalysisResponse = startDocumentAnalysis(StartDocumentAnalysisRequest.Builder().apply(block).build())

/**
 * Starts the asynchronous detection of text in a document. Amazon Textract can detect lines of text and the words that make up a line of text.
 *
 * `StartDocumentTextDetection` can analyze text in documents that are in JPEG, PNG, TIFF, and PDF format. The documents are stored in an Amazon S3 bucket. Use DocumentLocation to specify the bucket name and file name of the document.
 *
 * `StartTextDetection` returns a job identifier (`JobId`) that you use to get the results of the operation. When text detection is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you specify in `NotificationChannel`. To get the results of the text detection operation, first check that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call GetDocumentTextDetection, and pass the job identifier (`JobId`) from the initial call to `StartDocumentTextDetection`.
 *
 * For more information, see [Document Text Detection](https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
 */
public suspend inline fun TextractClient.startDocumentTextDetection(crossinline block: StartDocumentTextDetectionRequest.Builder.() -> Unit): StartDocumentTextDetectionResponse = startDocumentTextDetection(StartDocumentTextDetectionRequest.Builder().apply(block).build())

/**
 * Starts the asynchronous analysis of invoices or receipts for data like contact information, items purchased, and vendor names.
 *
 * `StartExpenseAnalysis` can analyze text in documents that are in JPEG, PNG, and PDF format. The documents must be stored in an Amazon S3 bucket. Use the DocumentLocation parameter to specify the name of your S3 bucket and the name of the document in that bucket.
 *
 * `StartExpenseAnalysis` returns a job identifier (`JobId`) that you will provide to `GetExpenseAnalysis` to retrieve the results of the operation. When the analysis of the input invoices/receipts is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you provide to the `NotificationChannel`. To obtain the results of the invoice and receipt analysis operation, ensure that the status value published to the Amazon SNS topic is `SUCCEEDED`. If so, call GetExpenseAnalysis, and pass the job identifier (`JobId`) that was returned by your call to `StartExpenseAnalysis`.
 *
 * For more information, see [Analyzing Invoices and Receipts](https://docs.aws.amazon.com/textract/latest/dg/invoice-receipts.html).
 */
public suspend inline fun TextractClient.startExpenseAnalysis(crossinline block: StartExpenseAnalysisRequest.Builder.() -> Unit): StartExpenseAnalysisResponse = startExpenseAnalysis(StartExpenseAnalysisRequest.Builder().apply(block).build())

/**
 * Starts the classification and analysis of an input document. `StartLendingAnalysis` initiates the classification and analysis of a packet of lending documents. `StartLendingAnalysis` operates on a document file located in an Amazon S3 bucket.
 *
 * `StartLendingAnalysis` can analyze text in documents that are in one of the following formats: JPEG, PNG, TIFF, PDF. Use `DocumentLocation` to specify the bucket name and the file name of the document.
 *
 * `StartLendingAnalysis` returns a job identifier (`JobId`) that you use to get the results of the operation. When the text analysis is finished, Amazon Textract publishes a completion status to the Amazon Simple Notification Service (Amazon SNS) topic that you specify in `NotificationChannel`. To get the results of the text analysis operation, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If the status is SUCCEEDED you can call either `GetLendingAnalysis` or `GetLendingAnalysisSummary` and provide the `JobId` to obtain the results of the analysis.
 *
 * If using `OutputConfig` to specify an Amazon S3 bucket, the output will be contained within the specified prefix in a directory labeled with the job-id. In the directory there are 3 sub-directories:
 * + detailedResponse (contains the GetLendingAnalysis response)
 * + summaryResponse (for the GetLendingAnalysisSummary response)
 * + splitDocuments (documents split across logical boundaries)
 */
public suspend inline fun TextractClient.startLendingAnalysis(crossinline block: StartLendingAnalysisRequest.Builder.() -> Unit): StartLendingAnalysisResponse = startLendingAnalysis(StartLendingAnalysisRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to the specified resource.
 */
public suspend inline fun TextractClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes any tags with the specified keys from the specified resource.
 */
public suspend inline fun TextractClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update the configuration for an adapter. FeatureTypes configurations cannot be updated. At least one new parameter must be specified as an argument.
 */
public suspend inline fun TextractClient.updateAdapter(crossinline block: UpdateAdapterRequest.Builder.() -> Unit): UpdateAdapterResponse = updateAdapter(UpdateAdapterRequest.Builder().apply(block).build())
