// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.serde

import aws.sdk.kotlin.services.textract.model.AdapterVersionDatasetConfig
import aws.sdk.kotlin.services.textract.model.AdapterVersionEvaluationMetric
import aws.sdk.kotlin.services.textract.model.AdapterVersionStatus
import aws.sdk.kotlin.services.textract.model.FeatureType
import aws.sdk.kotlin.services.textract.model.GetAdapterVersionResponse
import aws.sdk.kotlin.services.textract.model.OutputConfig
import aws.sdk.kotlin.services.textract.model.TextractException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetAdapterVersionOperationDeserializer: HttpDeserialize<GetAdapterVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetAdapterVersionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetAdapterVersionError(context, call)
        }
        val builder = GetAdapterVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAdapterVersionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetAdapterVersionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TextractException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> TextractException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAdapterVersionOperationBody(builder: GetAdapterVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADAPTERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AdapterId"))
    val ADAPTERVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AdapterVersion"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATASETCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DatasetConfig"))
    val EVALUATIONMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EvaluationMetrics"))
    val FEATURETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FeatureTypes"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KMSKeyId"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusMessage"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADAPTERID_DESCRIPTOR)
        field(ADAPTERVERSION_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DATASETCONFIG_DESCRIPTOR)
        field(EVALUATIONMETRICS_DESCRIPTOR)
        field(FEATURETYPES_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADAPTERID_DESCRIPTOR.index -> builder.adapterId = deserializeString()
                ADAPTERVERSION_DESCRIPTOR.index -> builder.adapterVersion = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATASETCONFIG_DESCRIPTOR.index -> builder.datasetConfig = deserializeAdapterVersionDatasetConfigDocument(deserializer)
                EVALUATIONMETRICS_DESCRIPTOR.index -> builder.evaluationMetrics =
                    deserializer.deserializeList(EVALUATIONMETRICS_DESCRIPTOR) {
                        val col0 = mutableListOf<AdapterVersionEvaluationMetric>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAdapterVersionEvaluationMetricDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FEATURETYPES_DESCRIPTOR.index -> builder.featureTypes =
                    deserializer.deserializeList(FEATURETYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<FeatureType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { FeatureType.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                OUTPUTCONFIG_DESCRIPTOR.index -> builder.outputConfig = deserializeOutputConfigDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AdapterVersionStatus.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
