// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.paginators

import aws.sdk.kotlin.services.textract.TextractClient
import aws.sdk.kotlin.services.textract.model.AdapterOverview
import aws.sdk.kotlin.services.textract.model.AdapterVersionOverview
import aws.sdk.kotlin.services.textract.model.ListAdapterVersionsRequest
import aws.sdk.kotlin.services.textract.model.ListAdapterVersionsResponse
import aws.sdk.kotlin.services.textract.model.ListAdaptersRequest
import aws.sdk.kotlin.services.textract.model.ListAdaptersResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAdaptersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAdaptersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAdaptersResponse]
 */
public fun TextractClient.listAdaptersPaginated(initialRequest: ListAdaptersRequest = ListAdaptersRequest { }): Flow<ListAdaptersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAdaptersPaginated.listAdapters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAdaptersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAdaptersResponse]
 */
public fun TextractClient.listAdaptersPaginated(block: ListAdaptersRequest.Builder.() -> Unit): Flow<ListAdaptersResponse> =
    listAdaptersPaginated(ListAdaptersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAdaptersPaginated]
 * to access the nested member [AdapterOverview]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AdapterOverview]
 */
@JvmName("listAdaptersResponseAdapterOverview")
public fun Flow<ListAdaptersResponse>.adapters(): Flow<AdapterOverview> =
    transform() { response ->
        response.adapters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAdapterVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAdapterVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAdapterVersionsResponse]
 */
public fun TextractClient.listAdapterVersionsPaginated(initialRequest: ListAdapterVersionsRequest = ListAdapterVersionsRequest { }): Flow<ListAdapterVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAdapterVersionsPaginated.listAdapterVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAdapterVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAdapterVersionsResponse]
 */
public fun TextractClient.listAdapterVersionsPaginated(block: ListAdapterVersionsRequest.Builder.() -> Unit): Flow<ListAdapterVersionsResponse> =
    listAdapterVersionsPaginated(ListAdapterVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAdapterVersionsPaginated]
 * to access the nested member [AdapterVersionOverview]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AdapterVersionOverview]
 */
@JvmName("listAdapterVersionsResponseAdapterVersionOverview")
public fun Flow<ListAdapterVersionsResponse>.adapterVersions(): Flow<AdapterVersionOverview> =
    transform() { response ->
        response.adapterVersions?.forEach {
            emit(it)
        }
    }
