// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



public class StartLendingAnalysisRequest private constructor(builder: Builder) {
    /**
     * The idempotent token that you use to identify the start request. If you use the same token with multiple `StartLendingAnalysis` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidentally started more than once. For more information, see [Calling Amazon Textract Asynchronous Operations](https://docs.aws.amazon.com/textract/latest/dg/api-sync.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The Amazon S3 bucket that contains the document to be processed. It's used by asynchronous operations.
     *
     * The input document can be an image file in JPEG or PNG format. It can also be a file in PDF format.
     */
    public val documentLocation: aws.sdk.kotlin.services.textract.model.DocumentLocation? = builder.documentLocation
    /**
     * An identifier that you specify to be included in the completion notification published to the Amazon SNS topic. For example, you can use `JobTag` to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).
     */
    public val jobTag: kotlin.String? = builder.jobTag
    /**
     * The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side, using SSE-S3.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon Simple Notification Service (Amazon SNS) topic to which Amazon Textract publishes the completion status of an asynchronous document operation.
     */
    public val notificationChannel: aws.sdk.kotlin.services.textract.model.NotificationChannel? = builder.notificationChannel
    /**
     * Sets whether or not your output will go to a user created bucket. Used to set the name of the bucket, and the prefix on the output file.
     *
     * `OutputConfig` is an optional parameter which lets you adjust where your output will be placed. By default, Amazon Textract will store the results internally and can only be accessed by the Get API operations. With `OutputConfig` enabled, you can set the name of the bucket the output will be sent to the file prefix of the results where you can download your results. Additionally, you can set the `KMSKeyID` parameter to a customer master key (CMK) to encrypt your output. Without this parameter set Amazon Textract will encrypt server-side using the AWS managed CMK for Amazon S3.
     *
     * Decryption of Customer Content is necessary for processing of the documents by Amazon Textract. If your account is opted out under an AI services opt out policy then all unencrypted Customer Content is immediately and permanently deleted after the Customer Content has been processed by the service. No copy of of the output is retained by Amazon Textract. For information about how to opt out, see [ Managing AI services opt-out policy. ](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
     *
     * For more information on data privacy, see the [Data Privacy FAQ](https://aws.amazon.com/compliance/data-privacy-faq/).
     */
    public val outputConfig: aws.sdk.kotlin.services.textract.model.OutputConfig? = builder.outputConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.StartLendingAnalysisRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartLendingAnalysisRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("documentLocation=$documentLocation,")
        append("jobTag=$jobTag,")
        append("kmsKeyId=$kmsKeyId,")
        append("notificationChannel=$notificationChannel,")
        append("outputConfig=$outputConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (documentLocation?.hashCode() ?: 0)
        result = 31 * result + (jobTag?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (notificationChannel?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartLendingAnalysisRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (documentLocation != other.documentLocation) return false
        if (jobTag != other.jobTag) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (notificationChannel != other.notificationChannel) return false
        if (outputConfig != other.outputConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.StartLendingAnalysisRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The idempotent token that you use to identify the start request. If you use the same token with multiple `StartLendingAnalysis` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidentally started more than once. For more information, see [Calling Amazon Textract Asynchronous Operations](https://docs.aws.amazon.com/textract/latest/dg/api-sync.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The Amazon S3 bucket that contains the document to be processed. It's used by asynchronous operations.
         *
         * The input document can be an image file in JPEG or PNG format. It can also be a file in PDF format.
         */
        public var documentLocation: aws.sdk.kotlin.services.textract.model.DocumentLocation? = null
        /**
         * An identifier that you specify to be included in the completion notification published to the Amazon SNS topic. For example, you can use `JobTag` to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).
         */
        public var jobTag: kotlin.String? = null
        /**
         * The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side, using SSE-S3.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon Simple Notification Service (Amazon SNS) topic to which Amazon Textract publishes the completion status of an asynchronous document operation.
         */
        public var notificationChannel: aws.sdk.kotlin.services.textract.model.NotificationChannel? = null
        /**
         * Sets whether or not your output will go to a user created bucket. Used to set the name of the bucket, and the prefix on the output file.
         *
         * `OutputConfig` is an optional parameter which lets you adjust where your output will be placed. By default, Amazon Textract will store the results internally and can only be accessed by the Get API operations. With `OutputConfig` enabled, you can set the name of the bucket the output will be sent to the file prefix of the results where you can download your results. Additionally, you can set the `KMSKeyID` parameter to a customer master key (CMK) to encrypt your output. Without this parameter set Amazon Textract will encrypt server-side using the AWS managed CMK for Amazon S3.
         *
         * Decryption of Customer Content is necessary for processing of the documents by Amazon Textract. If your account is opted out under an AI services opt out policy then all unencrypted Customer Content is immediately and permanently deleted after the Customer Content has been processed by the service. No copy of of the output is retained by Amazon Textract. For information about how to opt out, see [ Managing AI services opt-out policy. ](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
         *
         * For more information on data privacy, see the [Data Privacy FAQ](https://aws.amazon.com/compliance/data-privacy-faq/).
         */
        public var outputConfig: aws.sdk.kotlin.services.textract.model.OutputConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.StartLendingAnalysisRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.documentLocation = x.documentLocation
            this.jobTag = x.jobTag
            this.kmsKeyId = x.kmsKeyId
            this.notificationChannel = x.notificationChannel
            this.outputConfig = x.outputConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.StartLendingAnalysisRequest = StartLendingAnalysisRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.DocumentLocation] inside the given [block]
         */
        public fun documentLocation(block: aws.sdk.kotlin.services.textract.model.DocumentLocation.Builder.() -> kotlin.Unit) {
            this.documentLocation = aws.sdk.kotlin.services.textract.model.DocumentLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.NotificationChannel] inside the given [block]
         */
        public fun notificationChannel(block: aws.sdk.kotlin.services.textract.model.NotificationChannel.Builder.() -> kotlin.Unit) {
            this.notificationChannel = aws.sdk.kotlin.services.textract.model.NotificationChannel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.OutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.textract.model.OutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.textract.model.OutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
