// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



public class StartDocumentAnalysisRequest private constructor(builder: Builder) {
    /**
     * Specifies the adapter to be used when analyzing a document.
     */
    public val adaptersConfig: aws.sdk.kotlin.services.textract.model.AdaptersConfig? = builder.adaptersConfig
    /**
     * The idempotent token that you use to identify the start request. If you use the same token with multiple `StartDocumentAnalysis` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidentally started more than once. For more information, see [Calling Amazon Textract Asynchronous Operations](https://docs.aws.amazon.com/textract/latest/dg/api-async.html).
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The location of the document to be processed.
     */
    public val documentLocation: aws.sdk.kotlin.services.textract.model.DocumentLocation? = builder.documentLocation
    /**
     * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis, add TABLES and FORMS to `FeatureTypes`. All lines and words detected in the document are included in the response (including text that isn't related to the value of `FeatureTypes`).
     */
    public val featureTypes: List<FeatureType>? = builder.featureTypes
    /**
     * An identifier that you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use `JobTag` to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).
     */
    public val jobTag: kotlin.String? = builder.jobTag
    /**
     * The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to.
     */
    public val notificationChannel: aws.sdk.kotlin.services.textract.model.NotificationChannel? = builder.notificationChannel
    /**
     * Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save the results internally to be accessed by the GetDocumentAnalysis operation.
     */
    public val outputConfig: aws.sdk.kotlin.services.textract.model.OutputConfig? = builder.outputConfig
    /**
     *
     */
    public val queriesConfig: aws.sdk.kotlin.services.textract.model.QueriesConfig? = builder.queriesConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.StartDocumentAnalysisRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartDocumentAnalysisRequest(")
        append("adaptersConfig=$adaptersConfig,")
        append("clientRequestToken=$clientRequestToken,")
        append("documentLocation=$documentLocation,")
        append("featureTypes=$featureTypes,")
        append("jobTag=$jobTag,")
        append("kmsKeyId=$kmsKeyId,")
        append("notificationChannel=$notificationChannel,")
        append("outputConfig=$outputConfig,")
        append("queriesConfig=$queriesConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adaptersConfig?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (documentLocation?.hashCode() ?: 0)
        result = 31 * result + (featureTypes?.hashCode() ?: 0)
        result = 31 * result + (jobTag?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (notificationChannel?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (queriesConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartDocumentAnalysisRequest

        if (adaptersConfig != other.adaptersConfig) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (documentLocation != other.documentLocation) return false
        if (featureTypes != other.featureTypes) return false
        if (jobTag != other.jobTag) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (notificationChannel != other.notificationChannel) return false
        if (outputConfig != other.outputConfig) return false
        if (queriesConfig != other.queriesConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.StartDocumentAnalysisRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the adapter to be used when analyzing a document.
         */
        public var adaptersConfig: aws.sdk.kotlin.services.textract.model.AdaptersConfig? = null
        /**
         * The idempotent token that you use to identify the start request. If you use the same token with multiple `StartDocumentAnalysis` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidentally started more than once. For more information, see [Calling Amazon Textract Asynchronous Operations](https://docs.aws.amazon.com/textract/latest/dg/api-async.html).
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The location of the document to be processed.
         */
        public var documentLocation: aws.sdk.kotlin.services.textract.model.DocumentLocation? = null
        /**
         * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis, add TABLES and FORMS to `FeatureTypes`. All lines and words detected in the document are included in the response (including text that isn't related to the value of `FeatureTypes`).
         */
        public var featureTypes: List<FeatureType>? = null
        /**
         * An identifier that you specify that's included in the completion notification published to the Amazon SNS topic. For example, you can use `JobTag` to identify the type of document that the completion notification corresponds to (such as a tax form or a receipt).
         */
        public var jobTag: kotlin.String? = null
        /**
         * The KMS key used to encrypt the inference results. This can be in either Key ID or Key Alias format. When a KMS key is provided, the KMS key will be used for server-side encryption of the objects in the customer bucket. When this parameter is not enabled, the result will be encrypted server side,using SSE-S3.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to.
         */
        public var notificationChannel: aws.sdk.kotlin.services.textract.model.NotificationChannel? = null
        /**
         * Sets if the output will go to a customer defined bucket. By default, Amazon Textract will save the results internally to be accessed by the GetDocumentAnalysis operation.
         */
        public var outputConfig: aws.sdk.kotlin.services.textract.model.OutputConfig? = null
        /**
         *
         */
        public var queriesConfig: aws.sdk.kotlin.services.textract.model.QueriesConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.StartDocumentAnalysisRequest) : this() {
            this.adaptersConfig = x.adaptersConfig
            this.clientRequestToken = x.clientRequestToken
            this.documentLocation = x.documentLocation
            this.featureTypes = x.featureTypes
            this.jobTag = x.jobTag
            this.kmsKeyId = x.kmsKeyId
            this.notificationChannel = x.notificationChannel
            this.outputConfig = x.outputConfig
            this.queriesConfig = x.queriesConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.StartDocumentAnalysisRequest = StartDocumentAnalysisRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.AdaptersConfig] inside the given [block]
         */
        public fun adaptersConfig(block: aws.sdk.kotlin.services.textract.model.AdaptersConfig.Builder.() -> kotlin.Unit) {
            this.adaptersConfig = aws.sdk.kotlin.services.textract.model.AdaptersConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.DocumentLocation] inside the given [block]
         */
        public fun documentLocation(block: aws.sdk.kotlin.services.textract.model.DocumentLocation.Builder.() -> kotlin.Unit) {
            this.documentLocation = aws.sdk.kotlin.services.textract.model.DocumentLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.NotificationChannel] inside the given [block]
         */
        public fun notificationChannel(block: aws.sdk.kotlin.services.textract.model.NotificationChannel.Builder.() -> kotlin.Unit) {
            this.notificationChannel = aws.sdk.kotlin.services.textract.model.NotificationChannel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.OutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.textract.model.OutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.textract.model.OutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.QueriesConfig] inside the given [block]
         */
        public fun queriesConfig(block: aws.sdk.kotlin.services.textract.model.QueriesConfig.Builder.() -> kotlin.Unit) {
            this.queriesConfig = aws.sdk.kotlin.services.textract.model.QueriesConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
