// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetAdapterVersionResponse private constructor(builder: Builder) {
    /**
     * A string containing a unique ID for the adapter version being retrieved.
     */
    public val adapterId: kotlin.String? = builder.adapterId
    /**
     * A string containing the adapter version that has been retrieved.
     */
    public val adapterVersion: kotlin.String? = builder.adapterVersion
    /**
     * The time that the adapter version was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Specifies a dataset used to train a new adapter version. Takes a ManifestS3Objec as the value.
     */
    public val datasetConfig: aws.sdk.kotlin.services.textract.model.AdapterVersionDatasetConfig? = builder.datasetConfig
    /**
     * The evaluation metrics (F1 score, Precision, and Recall) for the requested version, grouped by baseline metrics and adapter version.
     */
    public val evaluationMetrics: List<AdapterVersionEvaluationMetric>? = builder.evaluationMetrics
    /**
     * List of the targeted feature types for the requested adapter version.
     */
    public val featureTypes: List<FeatureType>? = builder.featureTypes
    /**
     * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Sets whether or not your output will go to a user created bucket. Used to set the name of the bucket, and the prefix on the output file.
     *
     * `OutputConfig` is an optional parameter which lets you adjust where your output will be placed. By default, Amazon Textract will store the results internally and can only be accessed by the Get API operations. With `OutputConfig` enabled, you can set the name of the bucket the output will be sent to the file prefix of the results where you can download your results. Additionally, you can set the `KMSKeyID` parameter to a customer master key (CMK) to encrypt your output. Without this parameter set Amazon Textract will encrypt server-side using the AWS managed CMK for Amazon S3.
     *
     * Decryption of Customer Content is necessary for processing of the documents by Amazon Textract. If your account is opted out under an AI services opt out policy then all unencrypted Customer Content is immediately and permanently deleted after the Customer Content has been processed by the service. No copy of of the output is retained by Amazon Textract. For information about how to opt out, see [ Managing AI services opt-out policy. ](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
     *
     * For more information on data privacy, see the [Data Privacy FAQ](https://aws.amazon.com/compliance/data-privacy-faq/).
     */
    public val outputConfig: aws.sdk.kotlin.services.textract.model.OutputConfig? = builder.outputConfig
    /**
     * The status of the adapter version that has been requested.
     */
    public val status: aws.sdk.kotlin.services.textract.model.AdapterVersionStatus? = builder.status
    /**
     * A message that describes the status of the requested adapter version.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * A set of tags (key-value pairs) that are associated with the adapter version.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.GetAdapterVersionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAdapterVersionResponse(")
        append("adapterId=$adapterId,")
        append("adapterVersion=$adapterVersion,")
        append("creationTime=$creationTime,")
        append("datasetConfig=$datasetConfig,")
        append("evaluationMetrics=$evaluationMetrics,")
        append("featureTypes=$featureTypes,")
        append("kmsKeyId=$kmsKeyId,")
        append("outputConfig=$outputConfig,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adapterId?.hashCode() ?: 0
        result = 31 * result + (adapterVersion?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (datasetConfig?.hashCode() ?: 0)
        result = 31 * result + (evaluationMetrics?.hashCode() ?: 0)
        result = 31 * result + (featureTypes?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAdapterVersionResponse

        if (adapterId != other.adapterId) return false
        if (adapterVersion != other.adapterVersion) return false
        if (creationTime != other.creationTime) return false
        if (datasetConfig != other.datasetConfig) return false
        if (evaluationMetrics != other.evaluationMetrics) return false
        if (featureTypes != other.featureTypes) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (outputConfig != other.outputConfig) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.GetAdapterVersionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A string containing a unique ID for the adapter version being retrieved.
         */
        public var adapterId: kotlin.String? = null
        /**
         * A string containing the adapter version that has been retrieved.
         */
        public var adapterVersion: kotlin.String? = null
        /**
         * The time that the adapter version was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies a dataset used to train a new adapter version. Takes a ManifestS3Objec as the value.
         */
        public var datasetConfig: aws.sdk.kotlin.services.textract.model.AdapterVersionDatasetConfig? = null
        /**
         * The evaluation metrics (F1 score, Precision, and Recall) for the requested version, grouped by baseline metrics and adapter version.
         */
        public var evaluationMetrics: List<AdapterVersionEvaluationMetric>? = null
        /**
         * List of the targeted feature types for the requested adapter version.
         */
        public var featureTypes: List<FeatureType>? = null
        /**
         * The identifier for your AWS Key Management Service key (AWS KMS key). Used to encrypt your documents.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Sets whether or not your output will go to a user created bucket. Used to set the name of the bucket, and the prefix on the output file.
         *
         * `OutputConfig` is an optional parameter which lets you adjust where your output will be placed. By default, Amazon Textract will store the results internally and can only be accessed by the Get API operations. With `OutputConfig` enabled, you can set the name of the bucket the output will be sent to the file prefix of the results where you can download your results. Additionally, you can set the `KMSKeyID` parameter to a customer master key (CMK) to encrypt your output. Without this parameter set Amazon Textract will encrypt server-side using the AWS managed CMK for Amazon S3.
         *
         * Decryption of Customer Content is necessary for processing of the documents by Amazon Textract. If your account is opted out under an AI services opt out policy then all unencrypted Customer Content is immediately and permanently deleted after the Customer Content has been processed by the service. No copy of of the output is retained by Amazon Textract. For information about how to opt out, see [ Managing AI services opt-out policy. ](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
         *
         * For more information on data privacy, see the [Data Privacy FAQ](https://aws.amazon.com/compliance/data-privacy-faq/).
         */
        public var outputConfig: aws.sdk.kotlin.services.textract.model.OutputConfig? = null
        /**
         * The status of the adapter version that has been requested.
         */
        public var status: aws.sdk.kotlin.services.textract.model.AdapterVersionStatus? = null
        /**
         * A message that describes the status of the requested adapter version.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * A set of tags (key-value pairs) that are associated with the adapter version.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.GetAdapterVersionResponse) : this() {
            this.adapterId = x.adapterId
            this.adapterVersion = x.adapterVersion
            this.creationTime = x.creationTime
            this.datasetConfig = x.datasetConfig
            this.evaluationMetrics = x.evaluationMetrics
            this.featureTypes = x.featureTypes
            this.kmsKeyId = x.kmsKeyId
            this.outputConfig = x.outputConfig
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.GetAdapterVersionResponse = GetAdapterVersionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.AdapterVersionDatasetConfig] inside the given [block]
         */
        public fun datasetConfig(block: aws.sdk.kotlin.services.textract.model.AdapterVersionDatasetConfig.Builder.() -> kotlin.Unit) {
            this.datasetConfig = aws.sdk.kotlin.services.textract.model.AdapterVersionDatasetConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.textract.model.OutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.textract.model.OutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.textract.model.OutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
