// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



/**
 * An adapter selected for use when analyzing documents. Contains an adapter ID and a version number. Contains information on pages selected for analysis when analyzing documents asychronously.
 */
public class Adapter private constructor(builder: Builder) {
    /**
     * A unique identifier for the adapter resource.
     */
    public val adapterId: kotlin.String = requireNotNull(builder.adapterId) { "A non-null value must be provided for adapterId" }
    /**
     * Pages is a parameter that the user inputs to specify which pages to apply an adapter to. The following is a list of rules for using this parameter.
     * + If a page is not specified, it is set to `["1"]` by default.
     * + The following characters are allowed in the parameter's string: `0 1 2 3 4 5 6 7 8 9 - *`. No whitespace is allowed.
     * + When using * to indicate all pages, it must be the only element in the list.
     * + You can use page intervals, such as `["1-3", "1-1", "4-*"]`. Where `*` indicates last page of document.
     * + Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
     */
    public val pages: List<String>? = builder.pages
    /**
     * A string that identifies the version of the adapter.
     */
    public val version: kotlin.String = requireNotNull(builder.version) { "A non-null value must be provided for version" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.Adapter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Adapter(")
        append("adapterId=$adapterId,")
        append("pages=$pages,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adapterId.hashCode()
        result = 31 * result + (pages?.hashCode() ?: 0)
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Adapter

        if (adapterId != other.adapterId) return false
        if (pages != other.pages) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.Adapter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for the adapter resource.
         */
        public var adapterId: kotlin.String? = null
        /**
         * Pages is a parameter that the user inputs to specify which pages to apply an adapter to. The following is a list of rules for using this parameter.
         * + If a page is not specified, it is set to `["1"]` by default.
         * + The following characters are allowed in the parameter's string: `0 1 2 3 4 5 6 7 8 9 - *`. No whitespace is allowed.
         * + When using * to indicate all pages, it must be the only element in the list.
         * + You can use page intervals, such as `["1-3", "1-1", "4-*"]`. Where `*` indicates last page of document.
         * + Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
         */
        public var pages: List<String>? = null
        /**
         * A string that identifies the version of the adapter.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.Adapter) : this() {
            this.adapterId = x.adapterId
            this.pages = x.pages
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.Adapter = Adapter(this)

        internal fun correctErrors(): Builder {
            if (adapterId == null) adapterId = ""
            if (version == null) version = ""
            return this
        }
    }
}
