// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.transform

import aws.sdk.kotlin.services.textract.model.DocumentLocation
import aws.sdk.kotlin.services.textract.model.NotificationChannel
import aws.sdk.kotlin.services.textract.model.OutputConfig
import aws.sdk.kotlin.services.textract.model.StartExpenseAnalysisRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartExpenseAnalysisOperationSerializer: HttpSerialize<StartExpenseAnalysisRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartExpenseAnalysisRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeStartExpenseAnalysisOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeStartExpenseAnalysisOperationBody(context: ExecutionContext, input: StartExpenseAnalysisRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val DOCUMENTLOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DocumentLocation"))
    val JOBTAG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobTag"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KMSKeyId"))
    val NOTIFICATIONCHANNEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NotificationChannel"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(DOCUMENTLOCATION_DESCRIPTOR)
        field(JOBTAG_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(NOTIFICATIONCHANNEL_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) }
        input.documentLocation?.let { field(DOCUMENTLOCATION_DESCRIPTOR, it, ::serializeDocumentLocationDocument) }
        input.jobTag?.let { field(JOBTAG_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.notificationChannel?.let { field(NOTIFICATIONCHANNEL_DESCRIPTOR, it, ::serializeNotificationChannelDocument) }
        input.outputConfig?.let { field(OUTPUTCONFIG_DESCRIPTOR, it, ::serializeOutputConfigDocument) }
    }
    return serializer.toByteArray()
}
