// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.textract.model.Block
import aws.sdk.kotlin.services.textract.model.DocumentMetadata
import aws.sdk.kotlin.services.textract.model.GetDocumentTextDetectionResponse
import aws.sdk.kotlin.services.textract.model.JobStatus
import aws.sdk.kotlin.services.textract.model.TextractException
import aws.sdk.kotlin.services.textract.model.Warning
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDocumentTextDetectionOperationDeserializer: HttpDeserialize<GetDocumentTextDetectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDocumentTextDetectionResponse {
        if (!response.status.isSuccess()) {
            throwGetDocumentTextDetectionError(context, response)
        }
        val builder = GetDocumentTextDetectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDocumentTextDetectionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDocumentTextDetectionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TextractException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidJobIdException" -> InvalidJobIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidKMSKeyException" -> InvalidKmsKeyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidS3ObjectException" -> InvalidS3ObjectExceptionDeserializer().deserialize(context, wrappedResponse)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TextractException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDocumentTextDetectionOperationBody(builder: GetDocumentTextDetectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLOCKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Blocks"))
    val DETECTDOCUMENTTEXTMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DetectDocumentTextModelVersion"))
    val DOCUMENTMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DocumentMetadata"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobStatus"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusMessage"))
    val WARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Warnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOCKS_DESCRIPTOR)
        field(DETECTDOCUMENTTEXTMODELVERSION_DESCRIPTOR)
        field(DOCUMENTMETADATA_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
        field(WARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOCKS_DESCRIPTOR.index -> builder.blocks =
                    deserializer.deserializeList(BLOCKS_DESCRIPTOR) {
                        val col0 = mutableListOf<Block>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBlockDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DETECTDOCUMENTTEXTMODELVERSION_DESCRIPTOR.index -> builder.detectDocumentTextModelVersion = deserializeString()
                DOCUMENTMETADATA_DESCRIPTOR.index -> builder.documentMetadata = deserializeDocumentMetadataDocument(deserializer)
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { JobStatus.fromValue(it) }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                WARNINGS_DESCRIPTOR.index -> builder.warnings =
                    deserializer.deserializeList(WARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Warning>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWarningDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
