// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.textract.model.Block
import aws.sdk.kotlin.services.textract.model.DetectDocumentTextResponse
import aws.sdk.kotlin.services.textract.model.DocumentMetadata
import aws.sdk.kotlin.services.textract.model.TextractException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DetectDocumentTextOperationDeserializer: HttpDeserialize<DetectDocumentTextResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DetectDocumentTextResponse {
        if (!response.status.isSuccess()) {
            throwDetectDocumentTextError(context, response)
        }
        val builder = DetectDocumentTextResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDetectDocumentTextOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDetectDocumentTextError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TextractException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadDocumentException" -> BadDocumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "DocumentTooLargeException" -> DocumentTooLargeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidS3ObjectException" -> InvalidS3ObjectExceptionDeserializer().deserialize(context, wrappedResponse)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedDocumentException" -> UnsupportedDocumentExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TextractException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDetectDocumentTextOperationBody(builder: DetectDocumentTextResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLOCKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Blocks"))
    val DETECTDOCUMENTTEXTMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DetectDocumentTextModelVersion"))
    val DOCUMENTMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DocumentMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOCKS_DESCRIPTOR)
        field(DETECTDOCUMENTTEXTMODELVERSION_DESCRIPTOR)
        field(DOCUMENTMETADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOCKS_DESCRIPTOR.index -> builder.blocks =
                    deserializer.deserializeList(BLOCKS_DESCRIPTOR) {
                        val col0 = mutableListOf<Block>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBlockDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DETECTDOCUMENTTEXTMODELVERSION_DESCRIPTOR.index -> builder.detectDocumentTextModelVersion = deserializeString()
                DOCUMENTMETADATA_DESCRIPTOR.index -> builder.documentMetadata = deserializeDocumentMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
