// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.textract.model



/**
 * Each query contains the question you want to ask in the Text and the alias you want to associate.
 */
class Query private constructor(builder: Builder) {
    /**
     * Alias attached to the query, for ease of location.
     */
    val alias: kotlin.String? = builder.alias
    /**
     * List of pages associated with the query. The following is a list of rules for using this parameter.
     * + If a page is not specified, it is set to `["1"]` by default.
     * + The following characters are allowed in the parameter's string: `0 1 2 3 4 5 6 7 8 9 - *`. No whitespace is allowed.
     * + When using `*` to indicate all pages, it must be the only element in the string.
     * + You can use page intervals, such as `[“1-3”, “1-1”, “4-*”]`. Where `*` indicates last page of document.
     * + Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
     */
    val pages: List<String>? = builder.pages
    /**
     * Question that Amazon Textract will apply to the document. An example would be "What is the customer's SSN?"
     */
    val text: kotlin.String? = builder.text

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.textract.model.Query = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Query(")
        append("alias=$alias,")
        append("pages=$pages,")
        append("text=$text)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (pages?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Query

        if (alias != other.alias) return false
        if (pages != other.pages) return false
        if (text != other.text) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.textract.model.Query = Builder(this).apply(block).build()

    class Builder {
        /**
         * Alias attached to the query, for ease of location.
         */
        var alias: kotlin.String? = null
        /**
         * List of pages associated with the query. The following is a list of rules for using this parameter.
         * + If a page is not specified, it is set to `["1"]` by default.
         * + The following characters are allowed in the parameter's string: `0 1 2 3 4 5 6 7 8 9 - *`. No whitespace is allowed.
         * + When using `*` to indicate all pages, it must be the only element in the string.
         * + You can use page intervals, such as `[“1-3”, “1-1”, “4-*”]`. Where `*` indicates last page of document.
         * + Specified pages must be greater than 0 and less than or equal to the number of pages in the document.
         */
        var pages: List<String>? = null
        /**
         * Question that Amazon Textract will apply to the document. An example would be "What is the customer's SSN?"
         */
        var text: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.textract.model.Query) : this() {
            this.alias = x.alias
            this.pages = x.pages
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.textract.model.Query = Query(this)
    }
}
